# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/shopping/merchant/accounts/version"

require "googleauth"

module Google
  module Shopping
    module Merchant
      module Accounts
        ##
        # Create a new client object for AccountTaxService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::AccountTaxService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/AccountTaxService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the AccountTaxService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the AccountTaxService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.account_tax_service_available?}.
        #
        # ## About AccountTaxService
        #
        # Manages account level tax setting data.
        #
        # This API defines the following resource model:
        #
        # - [AccountTax][google.shopping.merchant.accounts.v1main.AccountTax]
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.account_tax_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:AccountTaxService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the AccountTaxService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.account_tax_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the AccountTaxService service,
        # or if the versioned client gem needs an update to support the AccountTaxService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.account_tax_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :AccountTaxService
          service_module = service_module.const_get :AccountTaxService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for AccountIssueService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::AccountIssueService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/AccountIssueService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the AccountIssueService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the AccountIssueService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.account_issue_service_available?}.
        #
        # ## About AccountIssueService
        #
        # Service to support `AccountIssueService` API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.account_issue_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:AccountIssueService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the AccountIssueService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.account_issue_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the AccountIssueService service,
        # or if the versioned client gem needs an update to support the AccountIssueService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.account_issue_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :AccountIssueService
          service_module = service_module.const_get :AccountIssueService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for UserService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::UserService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/UserService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the UserService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the UserService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.user_service_available?}.
        #
        # ## About UserService
        #
        # Service to support user API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.user_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:UserService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the UserService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.user_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the UserService service,
        # or if the versioned client gem needs an update to support the UserService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.user_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :UserService
          service_module = service_module.const_get :UserService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for AccountsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/AccountsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the AccountsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the AccountsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.accounts_service_available?}.
        #
        # ## About AccountsService
        #
        # Service to support Accounts API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.accounts_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:AccountsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the AccountsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.accounts_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the AccountsService service,
        # or if the versioned client gem needs an update to support the AccountsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.accounts_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :AccountsService
          service_module = service_module.const_get :AccountsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for AutofeedSettingsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::AutofeedSettingsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/AutofeedSettingsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the AutofeedSettingsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the AutofeedSettingsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.autofeed_settings_service_available?}.
        #
        # ## About AutofeedSettingsService
        #
        # Service to support
        # [autofeed](https://support.google.com/merchants/answer/7538732) setting.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.autofeed_settings_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:AutofeedSettingsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the AutofeedSettingsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.autofeed_settings_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the AutofeedSettingsService service,
        # or if the versioned client gem needs an update to support the AutofeedSettingsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.autofeed_settings_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :AutofeedSettingsService
          service_module = service_module.const_get :AutofeedSettingsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for AutomaticImprovementsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::AutomaticImprovementsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/AutomaticImprovementsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the AutomaticImprovementsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the AutomaticImprovementsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.automatic_improvements_service_available?}.
        #
        # ## About AutomaticImprovementsService
        #
        # Service to manage the automatic improvements of an account. The automatic
        # improvements of the account can be used to automatically update products,
        # improve images and shipping.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.automatic_improvements_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:AutomaticImprovementsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the AutomaticImprovementsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.automatic_improvements_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the AutomaticImprovementsService service,
        # or if the versioned client gem needs an update to support the AutomaticImprovementsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.automatic_improvements_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :AutomaticImprovementsService
          service_module = service_module.const_get :AutomaticImprovementsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for BusinessIdentityService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentityService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/BusinessIdentityService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the BusinessIdentityService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the BusinessIdentityService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.business_identity_service_available?}.
        #
        # ## About BusinessIdentityService
        #
        # Service to support [business
        # identity](https://support.google.com/merchants/answer/12564247) API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.business_identity_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:BusinessIdentityService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the BusinessIdentityService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.business_identity_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the BusinessIdentityService service,
        # or if the versioned client gem needs an update to support the BusinessIdentityService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.business_identity_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :BusinessIdentityService
          service_module = service_module.const_get :BusinessIdentityService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for BusinessInfoService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::BusinessInfoService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/BusinessInfoService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the BusinessInfoService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the BusinessInfoService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.business_info_service_available?}.
        #
        # ## About BusinessInfoService
        #
        # Service to support business info API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.business_info_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:BusinessInfoService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the BusinessInfoService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.business_info_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the BusinessInfoService service,
        # or if the versioned client gem needs an update to support the BusinessInfoService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.business_info_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :BusinessInfoService
          service_module = service_module.const_get :BusinessInfoService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for CheckoutSettingsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::CheckoutSettingsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/CheckoutSettingsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the CheckoutSettingsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the CheckoutSettingsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.checkout_settings_service_available?}.
        #
        # ## About CheckoutSettingsService
        #
        # Service for supporting [checkout
        # settings](https://support.google.com/merchants/answer/13945960).
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.checkout_settings_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:CheckoutSettingsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the CheckoutSettingsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.checkout_settings_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the CheckoutSettingsService service,
        # or if the versioned client gem needs an update to support the CheckoutSettingsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.checkout_settings_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :CheckoutSettingsService
          service_module = service_module.const_get :CheckoutSettingsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for EmailPreferencesService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::EmailPreferencesService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/EmailPreferencesService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the EmailPreferencesService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the EmailPreferencesService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.email_preferences_service_available?}.
        #
        # ## About EmailPreferencesService
        #
        # Service to support the `EmailPreferences` API.
        #
        # This service only permits retrieving and updating email preferences for the
        # authenticated user.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.email_preferences_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:EmailPreferencesService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the EmailPreferencesService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.email_preferences_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the EmailPreferencesService service,
        # or if the versioned client gem needs an update to support the EmailPreferencesService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.email_preferences_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :EmailPreferencesService
          service_module = service_module.const_get :EmailPreferencesService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for GbpAccountsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::GbpAccountsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/GbpAccountsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the GbpAccountsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the GbpAccountsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.gbp_accounts_service_available?}.
        #
        # ## About GbpAccountsService
        #
        # The service facilitates the management of a merchant's Google Business
        # Profile (GBP) account settings. This API defines the following resource
        # model:
        # - [GbpAccount][google.shopping.merchant.accounts.v1.GbpAccount]
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.gbp_accounts_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:GbpAccountsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the GbpAccountsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.gbp_accounts_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the GbpAccountsService service,
        # or if the versioned client gem needs an update to support the GbpAccountsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.gbp_accounts_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :GbpAccountsService
          service_module = service_module.const_get :GbpAccountsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for HomepageService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::HomepageService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/HomepageService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the HomepageService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the HomepageService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.homepage_service_available?}.
        #
        # ## About HomepageService
        #
        # Service to support an API for a store's homepage.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.homepage_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:HomepageService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the HomepageService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.homepage_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the HomepageService service,
        # or if the versioned client gem needs an update to support the HomepageService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.homepage_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :HomepageService
          service_module = service_module.const_get :HomepageService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for LfpProvidersService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::LfpProvidersService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/LfpProvidersService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the LfpProvidersService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the LfpProvidersService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.lfp_providers_service_available?}.
        #
        # ## About LfpProvidersService
        #
        # The service facilitates the management of a merchant's LFP provider settings.
        # This API defines the following resource model:
        # - [LfpProvider][google.shopping.merchant.accounts.v1.LfpProvider]
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.lfp_providers_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:LfpProvidersService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the LfpProvidersService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.lfp_providers_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the LfpProvidersService service,
        # or if the versioned client gem needs an update to support the LfpProvidersService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.lfp_providers_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :LfpProvidersService
          service_module = service_module.const_get :LfpProvidersService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for OmnichannelSettingsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/OmnichannelSettingsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the OmnichannelSettingsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the OmnichannelSettingsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.omnichannel_settings_service_available?}.
        #
        # ## About OmnichannelSettingsService
        #
        # The service facilitates the management of a merchant's omnichannel settings.
        # ## This API defines the following resource model:
        #
        # [OmnichannelSetting][google.shopping.merchant.accounts.v1.OmnichannelSetting]
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.omnichannel_settings_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:OmnichannelSettingsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the OmnichannelSettingsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.omnichannel_settings_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the OmnichannelSettingsService service,
        # or if the versioned client gem needs an update to support the OmnichannelSettingsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.omnichannel_settings_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :OmnichannelSettingsService
          service_module = service_module.const_get :OmnichannelSettingsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for OnlineReturnPolicyService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/OnlineReturnPolicyService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the OnlineReturnPolicyService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the OnlineReturnPolicyService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.online_return_policy_service_available?}.
        #
        # ## About OnlineReturnPolicyService
        #
        # The service facilitates the management of a merchant's remorse return policy
        # configuration, encompassing return policies for both ads and free listings
        # ## programs. This API defines the following resource model:
        #
        # [OnlineReturnPolicy](/merchant/api/reference/rpc/google.shopping.merchant.accounts.v1beta#google.shopping.merchant.accounts.v1beta.OnlineReturnPolicy)
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.online_return_policy_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:OnlineReturnPolicyService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the OnlineReturnPolicyService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.online_return_policy_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the OnlineReturnPolicyService service,
        # or if the versioned client gem needs an update to support the OnlineReturnPolicyService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.online_return_policy_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :OnlineReturnPolicyService
          service_module = service_module.const_get :OnlineReturnPolicyService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for ProgramsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::ProgramsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/ProgramsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the ProgramsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the ProgramsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.programs_service_available?}.
        #
        # ## About ProgramsService
        #
        # Service for program management.
        #
        # Programs provide a mechanism for adding functionality to merchant accounts. A
        # typical example of this is the [Free product
        # listings](https://support.google.com/merchants/topic/9240261?ref_topic=7257954,7259405,&sjid=796648681813264022-EU)
        # program, which enables products from a merchant's store to be shown across
        # Google for free.
        #
        # This service exposes methods to retrieve a merchant's
        # participation in all available programs, in addition to methods for
        # explicitly enabling or disabling participation in each program.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.programs_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:ProgramsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the ProgramsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.programs_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the ProgramsService service,
        # or if the versioned client gem needs an update to support the ProgramsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.programs_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :ProgramsService
          service_module = service_module.const_get :ProgramsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for RegionsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::RegionsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/RegionsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the RegionsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the RegionsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.regions_service_available?}.
        #
        # ## About RegionsService
        #
        # Manages regions configuration.
        #
        # This API defines the following resource model:
        #
        # - [Region][google.shopping.merchant.accounts.v1main.Region]
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.regions_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:RegionsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the RegionsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.regions_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the RegionsService service,
        # or if the versioned client gem needs an update to support the RegionsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.regions_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :RegionsService
          service_module = service_module.const_get :RegionsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for ShippingSettingsService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::ShippingSettingsService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/ShippingSettingsService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the ShippingSettingsService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the ShippingSettingsService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.shipping_settings_service_available?}.
        #
        # ## About ShippingSettingsService
        #
        # Service to get method call shipping setting information per Merchant API
        # method.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.shipping_settings_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:ShippingSettingsService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the ShippingSettingsService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.shipping_settings_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the ShippingSettingsService service,
        # or if the versioned client gem needs an update to support the ShippingSettingsService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.shipping_settings_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :ShippingSettingsService
          service_module = service_module.const_get :ShippingSettingsService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for TermsOfServiceService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::TermsOfServiceService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/TermsOfServiceService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the TermsOfServiceService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the TermsOfServiceService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.terms_of_service_service_available?}.
        #
        # ## About TermsOfServiceService
        #
        # Service to support `TermsOfService` API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.terms_of_service_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:TermsOfServiceService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the TermsOfServiceService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.terms_of_service_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the TermsOfServiceService service,
        # or if the versioned client gem needs an update to support the TermsOfServiceService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.terms_of_service_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :TermsOfServiceService
          service_module = service_module.const_get :TermsOfServiceService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end

        ##
        # Create a new client object for TermsOfServiceAgreementStateService.
        #
        # By default, this returns an instance of
        # [Google::Shopping::Merchant::Accounts::V1beta::TermsOfServiceAgreementStateService::Client](https://rubydoc.info/gems/google-shopping-merchant-accounts-v1beta/Google/Shopping/Merchant/Accounts/V1beta/TermsOfServiceAgreementStateService/Client)
        # for a gRPC client for version V1beta of the API.
        # However, you can specify a different API version by passing it in the
        # `version` parameter. If the TermsOfServiceAgreementStateService service is
        # supported by that API version, and the corresponding gem is available, the
        # appropriate versioned client will be returned.
        # You can also specify a different transport by passing `:rest` or `:grpc` in
        # the `transport` parameter.
        #
        # Raises an exception if the currently installed versioned client gem for the
        # given API version does not support the given transport of the TermsOfServiceAgreementStateService service.
        # You can determine whether the method will succeed by calling
        # {Google::Shopping::Merchant::Accounts.terms_of_service_agreement_state_service_available?}.
        #
        # ## About TermsOfServiceAgreementStateService
        #
        # Service to support `TermsOfServiceAgreementState` API.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [::Object] A client object for the specified version.
        #
        def self.terms_of_service_agreement_state_service version: :v1beta, transport: :grpc, &block
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"

          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          service_module = Google::Shopping::Merchant::Accounts.const_get(package_name).const_get(:TermsOfServiceAgreementStateService)
          service_module = service_module.const_get(:Rest) if transport == :rest
          service_module.const_get(:Client).new(&block)
        end

        ##
        # Determines whether the TermsOfServiceAgreementStateService service is supported by the current client.
        # If true, you can retrieve a client object by calling {Google::Shopping::Merchant::Accounts.terms_of_service_agreement_state_service}.
        # If false, that method will raise an exception. This could happen if the given
        # API version does not exist or does not support the TermsOfServiceAgreementStateService service,
        # or if the versioned client gem needs an update to support the TermsOfServiceAgreementStateService service.
        #
        # @param version [::String, ::Symbol] The API version to connect to. Optional.
        #   Defaults to `:v1beta`.
        # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
        # @return [boolean] Whether the service is available.
        #
        def self.terms_of_service_agreement_state_service_available? version: :v1beta, transport: :grpc
          require "google/shopping/merchant/accounts/#{version.to_s.downcase}"
          package_name = Google::Shopping::Merchant::Accounts
                         .constants
                         .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                         .first
          return false unless package_name
          service_module = Google::Shopping::Merchant::Accounts.const_get package_name
          return false unless service_module.const_defined? :TermsOfServiceAgreementStateService
          service_module = service_module.const_get :TermsOfServiceAgreementStateService
          if transport == :rest
            return false unless service_module.const_defined? :Rest
            service_module = service_module.const_get :Rest
          end
          service_module.const_defined? :Client
        rescue ::LoadError
          false
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "accounts", "helpers.rb"
require "google/shopping/merchant/accounts/helpers" if ::File.file? helper_path
