# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1beta/online_return_policy_pb"
require "google/shopping/merchant/accounts/v1beta/online_return_policy_service"

class ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_online_return_policy
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_online_return_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_online_return_policy, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::GetOnlineReturnPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_online_return_policy_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_online_return_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_online_return_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_online_return_policy ::Google::Shopping::Merchant::Accounts::V1beta::GetOnlineReturnPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_online_return_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_online_return_policy(::Google::Shopping::Merchant::Accounts::V1beta::GetOnlineReturnPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_online_return_policy_client_stub.call_rpc_count
    end
  end

  def test_list_online_return_policies
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::ListOnlineReturnPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_online_return_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_online_return_policies, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::ListOnlineReturnPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_online_return_policies_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_online_return_policies({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_online_return_policies parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_online_return_policies ::Google::Shopping::Merchant::Accounts::V1beta::ListOnlineReturnPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_online_return_policies({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_online_return_policies(::Google::Shopping::Merchant::Accounts::V1beta::ListOnlineReturnPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_online_return_policies_client_stub.call_rpc_count
    end
  end

  def test_create_online_return_policy
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    online_return_policy = {}

    create_online_return_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_online_return_policy, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::CreateOnlineReturnPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy), request["online_return_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_online_return_policy_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_online_return_policy({ parent: parent, online_return_policy: online_return_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_online_return_policy parent: parent, online_return_policy: online_return_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_online_return_policy ::Google::Shopping::Merchant::Accounts::V1beta::CreateOnlineReturnPolicyRequest.new(parent: parent, online_return_policy: online_return_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_online_return_policy({ parent: parent, online_return_policy: online_return_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_online_return_policy(::Google::Shopping::Merchant::Accounts::V1beta::CreateOnlineReturnPolicyRequest.new(parent: parent, online_return_policy: online_return_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_online_return_policy_client_stub.call_rpc_count
    end
  end

  def test_update_online_return_policy
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    online_return_policy = {}
    update_mask = {}

    update_online_return_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_online_return_policy, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::UpdateOnlineReturnPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy), request["online_return_policy"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_online_return_policy_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_online_return_policy({ online_return_policy: online_return_policy, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_online_return_policy online_return_policy: online_return_policy, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_online_return_policy ::Google::Shopping::Merchant::Accounts::V1beta::UpdateOnlineReturnPolicyRequest.new(online_return_policy: online_return_policy, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_online_return_policy({ online_return_policy: online_return_policy, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_online_return_policy(::Google::Shopping::Merchant::Accounts::V1beta::UpdateOnlineReturnPolicyRequest.new(online_return_policy: online_return_policy, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_online_return_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_online_return_policy
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_online_return_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_online_return_policy, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::DeleteOnlineReturnPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_online_return_policy_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_online_return_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_online_return_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_online_return_policy ::Google::Shopping::Merchant::Accounts::V1beta::DeleteOnlineReturnPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_online_return_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_online_return_policy(::Google::Shopping::Merchant::Accounts::V1beta::DeleteOnlineReturnPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_online_return_policy_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicyService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
