# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1beta/omnichannelsettings_pb"
require "google/shopping/merchant/accounts/v1beta/omnichannel_settings_service"

class ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_omnichannel_setting
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSetting.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_omnichannel_setting_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_omnichannel_setting, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::GetOmnichannelSettingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_omnichannel_setting_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_omnichannel_setting({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_omnichannel_setting name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_omnichannel_setting ::Google::Shopping::Merchant::Accounts::V1beta::GetOmnichannelSettingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_omnichannel_setting({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_omnichannel_setting(::Google::Shopping::Merchant::Accounts::V1beta::GetOmnichannelSettingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_omnichannel_setting_client_stub.call_rpc_count
    end
  end

  def test_list_omnichannel_settings
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::ListOmnichannelSettingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_omnichannel_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_omnichannel_settings, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::ListOmnichannelSettingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_omnichannel_settings_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_omnichannel_settings({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_omnichannel_settings parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_omnichannel_settings ::Google::Shopping::Merchant::Accounts::V1beta::ListOmnichannelSettingsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_omnichannel_settings({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_omnichannel_settings(::Google::Shopping::Merchant::Accounts::V1beta::ListOmnichannelSettingsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_omnichannel_settings_client_stub.call_rpc_count
    end
  end

  def test_create_omnichannel_setting
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSetting.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    omnichannel_setting = {}

    create_omnichannel_setting_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_omnichannel_setting, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::CreateOmnichannelSettingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSetting), request["omnichannel_setting"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_omnichannel_setting_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_omnichannel_setting({ parent: parent, omnichannel_setting: omnichannel_setting }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_omnichannel_setting parent: parent, omnichannel_setting: omnichannel_setting do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_omnichannel_setting ::Google::Shopping::Merchant::Accounts::V1beta::CreateOmnichannelSettingRequest.new(parent: parent, omnichannel_setting: omnichannel_setting) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_omnichannel_setting({ parent: parent, omnichannel_setting: omnichannel_setting }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_omnichannel_setting(::Google::Shopping::Merchant::Accounts::V1beta::CreateOmnichannelSettingRequest.new(parent: parent, omnichannel_setting: omnichannel_setting), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_omnichannel_setting_client_stub.call_rpc_count
    end
  end

  def test_update_omnichannel_setting
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSetting.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    omnichannel_setting = {}
    update_mask = {}

    update_omnichannel_setting_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_omnichannel_setting, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::UpdateOmnichannelSettingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSetting), request["omnichannel_setting"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_omnichannel_setting_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_omnichannel_setting({ omnichannel_setting: omnichannel_setting, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_omnichannel_setting omnichannel_setting: omnichannel_setting, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_omnichannel_setting ::Google::Shopping::Merchant::Accounts::V1beta::UpdateOmnichannelSettingRequest.new(omnichannel_setting: omnichannel_setting, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_omnichannel_setting({ omnichannel_setting: omnichannel_setting, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_omnichannel_setting(::Google::Shopping::Merchant::Accounts::V1beta::UpdateOmnichannelSettingRequest.new(omnichannel_setting: omnichannel_setting, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_omnichannel_setting_client_stub.call_rpc_count
    end
  end

  def test_request_inventory_verification
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1beta::RequestInventoryVerificationResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    request_inventory_verification_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :request_inventory_verification, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::RequestInventoryVerificationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, request_inventory_verification_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.request_inventory_verification({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.request_inventory_verification name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.request_inventory_verification ::Google::Shopping::Merchant::Accounts::V1beta::RequestInventoryVerificationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.request_inventory_verification({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.request_inventory_verification(::Google::Shopping::Merchant::Accounts::V1beta::RequestInventoryVerificationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, request_inventory_verification_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::OmnichannelSettingsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
