# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/shopping/merchant/accounts/v1beta/accounts_pb"
require "google/shopping/merchant/accounts/v1beta/accounts_service/rest"


class ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_account
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1beta::Account.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_get_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_account_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_account({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_account name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_account ::Google::Shopping::Merchant::Accounts::V1beta::GetAccountRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_account({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_account(::Google::Shopping::Merchant::Accounts::V1beta::GetAccountRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_account_client_stub.call_count
      end
    end
  end

  def test_create_and_configure_account
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1beta::Account.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = {}
    users = [{}]
    accept_terms_of_service = {}
    service = [{}]

    create_and_configure_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_create_and_configure_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_and_configure_account_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_and_configure_account({ account: account, users: users, accept_terms_of_service: accept_terms_of_service, service: service }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_and_configure_account account: account, users: users, accept_terms_of_service: accept_terms_of_service, service: service do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_and_configure_account ::Google::Shopping::Merchant::Accounts::V1beta::CreateAndConfigureAccountRequest.new(account: account, users: users, accept_terms_of_service: accept_terms_of_service, service: service) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_and_configure_account({ account: account, users: users, accept_terms_of_service: accept_terms_of_service, service: service }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_and_configure_account(::Google::Shopping::Merchant::Accounts::V1beta::CreateAndConfigureAccountRequest.new(account: account, users: users, accept_terms_of_service: accept_terms_of_service, service: service), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_and_configure_account_client_stub.call_count
      end
    end
  end

  def test_delete_account
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_delete_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_account_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_account({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_account name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_account ::Google::Shopping::Merchant::Accounts::V1beta::DeleteAccountRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_account({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_account(::Google::Shopping::Merchant::Accounts::V1beta::DeleteAccountRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_account_client_stub.call_count
      end
    end
  end

  def test_update_account
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1beta::Account.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    account = {}
    update_mask = {}

    update_account_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_update_account_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_account_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_account({ account: account, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_account account: account, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_account ::Google::Shopping::Merchant::Accounts::V1beta::UpdateAccountRequest.new(account: account, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_account({ account: account, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_account(::Google::Shopping::Merchant::Accounts::V1beta::UpdateAccountRequest.new(account: account, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_account_client_stub.call_count
      end
    end
  end

  def test_list_accounts
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1beta::ListAccountsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_accounts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_list_accounts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_accounts_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_accounts({ page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_accounts page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_accounts ::Google::Shopping::Merchant::Accounts::V1beta::ListAccountsRequest.new(page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_accounts({ page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_accounts(::Google::Shopping::Merchant::Accounts::V1beta::ListAccountsRequest.new(page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_accounts_client_stub.call_count
      end
    end
  end

  def test_list_sub_accounts
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1beta::ListSubAccountsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    provider = "hello world"
    page_size = 42
    page_token = "hello world"

    list_sub_accounts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::ServiceStub.stub :transcode_list_sub_accounts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_sub_accounts_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_sub_accounts({ provider: provider, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_sub_accounts provider: provider, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_sub_accounts ::Google::Shopping::Merchant::Accounts::V1beta::ListSubAccountsRequest.new(provider: provider, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_sub_accounts({ provider: provider, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_sub_accounts(::Google::Shopping::Merchant::Accounts::V1beta::ListSubAccountsRequest.new(provider: provider, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_sub_accounts_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1beta::AccountsService::Rest::Client::Configuration, config
  end
end
