# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Type
      # The weight represented as the value in string and the unit.
      # @!attribute [rw] amount_micros
      #   @return [::Integer]
      #     Required. The weight represented as a number in micros (1 million micros is
      #     an equivalent to one's currency standard unit, for example, 1 kg = 1000000
      #     micros).
      #     This field can also be set as infinity by setting to -1.
      #     This field only support -1 and positive value.
      # @!attribute [rw] unit
      #   @return [::Google::Shopping::Type::Weight::WeightUnit]
      #     Required. The weight unit.
      #     Acceptable values are: kg and lb
      class Weight
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # The weight unit.
        module WeightUnit
          # unit unspecified
          WEIGHT_UNIT_UNSPECIFIED = 0

          # lb unit.
          POUND = 1

          # kg unit.
          KILOGRAM = 2
        end
      end

      # The price represented as a number and currency.
      # @!attribute [rw] amount_micros
      #   @return [::Integer]
      #     The price represented as a number in micros (1 million micros is an
      #     equivalent to one's currency standard unit, for example, 1 USD = 1000000
      #     micros).
      # @!attribute [rw] currency_code
      #   @return [::String]
      #     The currency of the price using three-letter acronyms according to [ISO
      #     4217](http://en.wikipedia.org/wiki/ISO_4217).
      class Price
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # A message that represents custom attributes. Exactly one of `value` or
      # `group_values` must not be empty.
      # @!attribute [rw] name
      #   @return [::String]
      #     The name of the attribute.
      # @!attribute [rw] value
      #   @return [::String]
      #     The value of the attribute. If `value` is not empty, `group_values` must be
      #     empty.
      # @!attribute [rw] group_values
      #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
      #     Subattributes within this attribute group.  If
      #     `group_values` is not empty, `value` must be empty.
      class CustomAttribute
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods
      end

      # Destinations available for a product.
      #
      # Destinations are used in Merchant Center to allow you to control where the
      # products from your data feed should be displayed.
      class Destination
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # Destination values.
        module DestinationEnum
          # Not specified.
          DESTINATION_ENUM_UNSPECIFIED = 0

          # [Shopping ads](https://support.google.com/google-ads/answer/2454022).
          SHOPPING_ADS = 1

          # [Display ads](https://support.google.com/merchants/answer/6069387).
          DISPLAY_ADS = 2

          # [Local inventory
          # ads](https://support.google.com/merchants/answer/3057972).
          LOCAL_INVENTORY_ADS = 3

          # [Free listings](https://support.google.com/merchants/answer/9199328).
          FREE_LISTINGS = 4

          # [Free local product
          # listings](https://support.google.com/merchants/answer/9825611).
          FREE_LOCAL_LISTINGS = 5

          # [YouTube Shopping](https://support.google.com/merchants/answer/12362804).
          YOUTUBE_SHOPPING = 6
        end
      end

      # Reporting contexts that your account and product issues apply to.
      #
      # Reporting contexts are groups of surfaces and formats for product results on
      # Google. They can represent the entire destination (for example, [Shopping
      # ads](https://support.google.com/merchants/answer/6149970)) or a subset of
      # formats within a destination (for example, [Demand Gen
      # ads](https://support.google.com/merchants/answer/13389785)).
      class ReportingContext
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # Reporting context values.
        module ReportingContextEnum
          # Not specified.
          REPORTING_CONTEXT_ENUM_UNSPECIFIED = 0

          # [Shopping ads](https://support.google.com/merchants/answer/6149970).
          SHOPPING_ADS = 1

          # Deprecated:  Use `DEMAND_GEN_ADS` instead.
          # [Discovery and Demand Gen
          # ads](https://support.google.com/merchants/answer/13389785).
          DISCOVERY_ADS = 2

          # [Demand Gen ads](https://support.google.com/merchants/answer/13389785).
          DEMAND_GEN_ADS = 13

          # [Demand Gen ads on Discover
          # surface](https://support.google.com/merchants/answer/13389785).
          DEMAND_GEN_ADS_DISCOVER_SURFACE = 14

          # [Video ads](https://support.google.com/google-ads/answer/6340491).
          VIDEO_ADS = 3

          # [Display ads](https://support.google.com/merchants/answer/6069387).
          DISPLAY_ADS = 4

          # [Local inventory
          # ads](https://support.google.com/merchants/answer/3271956).
          LOCAL_INVENTORY_ADS = 5

          # [Vehicle inventory
          # ads](https://support.google.com/merchants/answer/11544533).
          VEHICLE_INVENTORY_ADS = 6

          # [Free product
          # listings](https://support.google.com/merchants/answer/9199328).
          FREE_LISTINGS = 7

          # [Free local product
          # listings](https://support.google.com/merchants/answer/9825611).
          FREE_LOCAL_LISTINGS = 8

          # [Free local vehicle
          # listings](https://support.google.com/merchants/answer/11544533).
          FREE_LOCAL_VEHICLE_LISTINGS = 9

          # [YouTube
          # Shopping](https://support.google.com/merchants/answer/13478370).
          YOUTUBE_SHOPPING = 10

          # [Cloud retail](https://cloud.google.com/solutions/retail).
          CLOUD_RETAIL = 11

          # [Local cloud retail](https://cloud.google.com/solutions/retail).
          LOCAL_CLOUD_RETAIL = 12
        end
      end

      # [Channel](https://support.google.com/merchants/answer/7361332) of a product.
      #
      # Channel is used to distinguish between online and local products.
      class Channel
        include ::Google::Protobuf::MessageExts
        extend ::Google::Protobuf::MessageExts::ClassMethods

        # Channel values.
        module ChannelEnum
          # Not specified.
          CHANNEL_ENUM_UNSPECIFIED = 0

          # Online product.
          ONLINE = 1

          # Local product.
          LOCAL = 2
        end
      end
    end
  end
end
