# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Settings related to the verification email that is sent after adding a user.
          # @!attribute [rw] verification_mail_mode
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::VerificationMailSettings::VerificationMailMode]
          #     Optional. Mode of the verification mail. If not set, the default is
          #     `SEND_VERIFICATION_MAIL`.
          class VerificationMailSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The different configuration options for sending a verification email
            # when adding a user.
            module VerificationMailMode
              # Default first member of every enum. Do not use.
              VERIFICATION_MAIL_MODE_UNSPECIFIED = 0

              # An invitation email is sent to the user added shortly after.
              SEND_VERIFICATION_MAIL = 1

              # No invitation email is sent. This can be useful if the user is
              # expected to accept the invitation through the API without needing
              # another notification.
              SUPPRESS_VERIFICATION_MAIL = 2
            end
          end
        end
      end
    end
  end
end
