# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # A [user](https://support.google.com/merchants/answer/12160472).
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the user.
          #     Format: `accounts/{account}/user/{email}`
          #
          #     Use `me` to refer to your own email address, for example
          #     `accounts/{account}/users/me`.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::User::State]
          #     Output only. The state of the user.
          # @!attribute [rw] access_rights
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::AccessRight>]
          #     Optional. The [access
          #     rights](https://support.google.com/merchants/answer/12160472?sjid=6789834943175119429-EU#accesstypes)
          #     the user has.
          class User
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The possible states of a user.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The user is pending confirmation. In this state, the user first needs to
              # accept the invitation before performing other actions.
              PENDING = 1

              # The user is verified.
              VERIFIED = 2
            end
          end

          # Request message for the `GetUser` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the user to retrieve.
          #     Format: `accounts/{account}/users/{email}`
          #
          #     It is also possible to retrieve the user corresponding to the caller by
          #     using `me` rather than an email address as in
          #     `accounts/{account}/users/me`.
          class GetUserRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `CreateUser` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the account for which a user will be
          #     created. Format: `accounts/{account}`
          # @!attribute [rw] user_id
          #   @return [::String]
          #     Required. The email address of the user (for example,
          #     `john.doe@gmail.com`).
          # @!attribute [rw] user
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::User]
          #     Required. The user to create.
          class CreateUserRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `DeleteUser` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the user to delete.
          #     Format: `accounts/{account}/users/{email}`
          #
          #     It is also possible to delete the user corresponding to the caller by using
          #     `me` rather than an email address as in `accounts/{account}/users/me`.
          class DeleteUserRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateUser` method.
          # @!attribute [rw] user
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::User]
          #     Required. The new version of the user.
          #
          #     Use `me` to refer to your own email address, for example
          #     `accounts/{account}/users/me`.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateUserRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListUsers` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent, which owns this collection of users.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of users to return. The service may return
          #     fewer than this value. If unspecified, at most 50 users will be returned.
          #     The maximum value is 100; values above 100 will be coerced to 100
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListUsers` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListUsers` must match
          #     the call that provided the page token.
          class ListUsersRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListUsers` method.
          # @!attribute [rw] users
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::User>]
          #     The users from the specified account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListUsersResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
