# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Primary type convension
          #
          # percent micro : 100% = 1 000 000 and 1% = 10 000
          #                 cannot be negative.
          #
          # Information about tax nexus and related parameters applicable to orders
          # delivered to the area covered by a single tax admin. Nexus is created when a
          # merchant is doing business in an area administered by tax admin (only US
          # states are supported for nexus configuration). If merchant has nexus in a US
          # state, merchant needs to pay tax to all tax authorities associated with
          # the shipping destination.
          # Next Id : 8
          # @!attribute [rw] location_id
          #   @return [::Integer]
          #     The admin_id or criteria_id of the region in which this rule is
          #     applicable.
          #
          #     Note: The following fields are mutually exclusive: `location_id`, `post_code_range`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] post_code_range
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::TaxRule::TaxPostalCodeRange]
          #     The range of postal codes in which this rule is applicable.
          #
          #     Note: The following fields are mutually exclusive: `post_code_range`, `location_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] use_google_rate
          #   @return [::Boolean]
          #     Rate that depends on delivery location: if merchant has a nexus in
          #     corresponding US state, rates from authorities with jurisdiction over
          #     delivery area are added up.
          #
          #     Note: The following fields are mutually exclusive: `use_google_rate`, `self_specified_rate_micros`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] self_specified_rate_micros
          #   @return [::Integer]
          #     A fixed rate specified in micros, where 100% = 1_000_000.
          #     Suitable for origin-based states.
          #
          #     Note: The following fields are mutually exclusive: `self_specified_rate_micros`, `use_google_rate`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Region code in which this rule is applicable
          # @!attribute [rw] shipping_taxed
          #   @return [::Boolean]
          #     If set, shipping charge is taxed (at the same rate as product) when
          #     delivering to this admin's area.
          #     Can only be set on US states without category.
          # @!attribute [rw] effective_time_period
          #   @return [::Google::Type::Interval]
          #     Required. Time period when this rule is effective. If the duration is
          #     missing from effective_time listed, then it is open ended to the future.
          #     The start of this time period is inclusive, and the end is exclusive.
          class TaxRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A range of postal codes that defines the area.
            # @!attribute [rw] start
            #   @return [::String]
            #     Required. The start of the postal code range, which is also the smallest
            #     in the range.
            # @!attribute [rw] end
            #   @return [::String]
            #     The end of the postal code range. Will be the same as start if not
            #     specified.
            class TaxPostalCodeRange
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
