# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # The merchant account's [shipping
          # setting](https://support.google.com/merchants/answer/6069284).
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the shipping setting.
          #     Format: `accounts/{account}/shippingSetting`
          # @!attribute [rw] services
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Service>]
          #     Optional. The target account's list of services.
          # @!attribute [rw] warehouses
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Warehouse>]
          #     Optional. A list of warehouses which can be referred to in `services`.
          # @!attribute [rw] etag
          #   @return [::String]
          #     Required. This field is used for avoid async issue. Make sure shipping
          #     setting data
          #      didn't change between get call and insert call. The user should do
          #      following steps：
          #
          #     1. Set etag field as empty string for initial shipping setting creation.
          #
          #     2. After initial creation, call get method to obtain an etag and current
          #     shipping setting data before call insert.
          #
          #     3. Modify to wanted shipping setting information.
          #
          #     4. Call insert method with the wanted shipping setting information with
          #     the etag obtained from step 2.
          #
          #     5. If shipping setting data changed between step 2 and step 4. Insert
          #     request will fail because the etag changes every time the shipping setting
          #     data changes. User should repeate step 2-4 with the new etag.
          class ShippingSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Shipping service.
          # @!attribute [rw] service_name
          #   @return [::String]
          #     Required. Free-form name of the service. Must be unique within target
          #     account.
          # @!attribute [rw] active
          #   @return [::Boolean]
          #     Required. A boolean exposing the active status of the shipping service.
          # @!attribute [rw] delivery_countries
          #   @return [::Array<::String>]
          #     Required. The CLDR territory code of the countries to which the service
          #     applies.
          # @!attribute [rw] currency_code
          #   @return [::String]
          #     The CLDR code of the currency to which this service applies. Must match
          #     that of the prices in rate groups.
          # @!attribute [rw] delivery_time
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::DeliveryTime]
          #     Required. Time spent in various aspects from order to the delivery of the
          #     product.
          # @!attribute [rw] rate_groups
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::RateGroup>]
          #     Optional. Shipping rate group definitions. Only the last one is allowed to
          #     have an empty `applicable_shipping_labels`, which means "everything else".
          #     The other `applicable_shipping_labels` must not overlap.
          # @!attribute [rw] shipment_type
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Service::ShipmentType]
          #     Type of locations this service ships orders to.
          # @!attribute [rw] minimum_order_value
          #   @return [::Google::Shopping::Type::Price]
          #     Minimum order value for this service. If set, indicates that customers
          #     will have to spend at least this amount.
          #     All prices within a service must have the same currency.
          #     Cannot be set together with minimum_order_value_table.
          # @!attribute [rw] minimum_order_value_table
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::MinimumOrderValueTable]
          #     Table of per store minimum order values for the pickup fulfillment type.
          #     Cannot be set together with minimum_order_value.
          # @!attribute [rw] store_config
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Service::StoreConfig]
          #     A list of stores your products are delivered from.
          #     This is only valid for the local delivery shipment type.
          # @!attribute [rw] loyalty_programs
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Service::LoyaltyProgram>]
          #     Optional. Loyalty programs that this shipping service is limited to.
          class Service
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A list of stores your products are delivered from.
            # This is only valid for the local delivery shipment type.
            # @!attribute [rw] store_service_type
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Service::StoreConfig::StoreServiceType]
            #     Indicates whether all stores, or selected stores, listed by this
            #     merchant provide local delivery.
            # @!attribute [rw] store_codes
            #   @return [::Array<::String>]
            #     Optional. A list of store codes that provide local delivery.
            #     If empty, then `all_stores` must be true.
            # @!attribute [rw] cutoff_config
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Service::StoreConfig::CutoffConfig]
            #     Configs related to local delivery ends for the day.
            # @!attribute [rw] service_radius
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Distance]
            #     Maximum delivery radius.
            #     This is only required for the local delivery shipment type.
            class StoreConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Configs related to local delivery ends for the day.
              # @!attribute [rw] local_cutoff_time
              #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Service::StoreConfig::CutoffConfig::LocalCutoffTime]
              #     Time that local delivery ends for the day.
              # @!attribute [rw] store_close_offset_hours
              #   @return [::Integer]
              #     Only valid with local delivery fulfillment. Represents cutoff time
              #     as the number of hours before store closing. Mutually exclusive
              #     with `local_cutoff_time`.
              # @!attribute [rw] no_delivery_post_cutoff
              #   @return [::Boolean]
              #     Merchants can opt-out of showing n+1 day local delivery when they have
              #     a shipping service configured to n day local delivery. For example, if
              #     the shipping service defines same-day delivery, and it's past the
              #     cut-off, setting this field to `true` results in the calculated
              #     shipping service rate returning `NO_DELIVERY_POST_CUTOFF`. In the
              #     same example, setting this field to `false` results in the calculated
              #     shipping time being one day. This is only for local delivery.
              class CutoffConfig
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # Time that local delivery ends for the day.
                # @!attribute [rw] hour
                #   @return [::Integer]
                #     Hour local delivery orders must be placed by to process the same
                #     day.
                # @!attribute [rw] minute
                #   @return [::Integer]
                #     Minute local delivery orders must be placed by to process the same
                #     day.
                class LocalCutoffTime
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end
              end

              # Indicates whether all stores, or selected stores, listed by the
              # merchant provide local delivery.
              module StoreServiceType
                # Did not specify store service type.
                STORE_SERVICE_TYPE_UNSPECIFIED = 0

                # Indicates whether all stores, current and future, listed by this
                # merchant provide local delivery.
                ALL_STORES = 1

                # Indicates that only the stores listed in `store_codes` are eligible
                # for local delivery.
                SELECTED_STORES = 2
              end
            end

            # [Loyalty program](https://support.google.com/merchants/answer/12922446)
            # provided by a merchant.
            # @!attribute [rw] program_label
            #   @return [::String]
            #     This is the loyalty program label set in your loyalty program settings in
            #     Merchant Center. This sub-attribute allows Google to map your loyalty
            #     program to eligible offers.
            # @!attribute [rw] loyalty_program_tiers
            #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Service::LoyaltyProgram::LoyaltyProgramTiers>]
            #     Optional. Loyalty program tier of this shipping service.
            class LoyaltyProgram
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Subset of a merchants loyalty program.
              # @!attribute [rw] tier_label
              #   @return [::String]
              #     The tier label [tier_label] sub-attribute differentiates offer level
              #     benefits between each tier. This value is also set in your program
              #     settings in Merchant Center, and is required for data source changes
              #     even if your loyalty program only has 1 tier.
              class LoyaltyProgramTiers
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # Shipment type of shipping service.
            module ShipmentType
              # This service did not specify shipment type.
              SHIPMENT_TYPE_UNSPECIFIED = 0

              # This service ships orders to an address chosen by the customer.
              DELIVERY = 1

              # This service ships orders to an address chosen by the customer.
              # The order is shipped from a local store near by.
              LOCAL_DELIVERY = 2

              # This service ships orders to an address chosen by the customer.
              # The order is shipped from a collection point.
              COLLECTION_POINT = 3
            end
          end

          # Maximum delivery radius.
          # This is only required for the local delivery shipment type.
          # @!attribute [rw] value
          #   @return [::Integer]
          #     Integer value of distance.
          # @!attribute [rw] unit
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Distance::Unit]
          #     Unit can differ based on country, it is parameterized to include miles
          #     and kilometers.
          class Distance
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Unit can differ based on country, it is parameterized to include miles
            # and kilometers.
            module Unit
              # Unit unspecified
              UNIT_UNSPECIFIED = 0

              # Unit in miles
              MILES = 1

              # Unit in kilometers
              KILOMETERS = 2
            end
          end

          # A fulfillment warehouse, which stores and handles inventory.
          # Next tag: 7
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the warehouse. Must be unique within account.
          # @!attribute [rw] shipping_address
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Address]
          #     Required. Shipping address of the warehouse.
          # @!attribute [rw] cutoff_time
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::WarehouseCutoffTime]
          #     Required. The latest time of day that an order can be accepted and begin
          #     processing. Later orders will be processed in the next day. The time is
          #     based on the warehouse postal code.
          # @!attribute [rw] handling_days
          #   @return [::Integer]
          #     Required. The number of days it takes for this warehouse to pack up and
          #     ship an item. This is on the warehouse level, but can be overridden on the
          #     offer level based on the attributes of an item.
          # @!attribute [rw] business_day_config
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessDayConfig]
          #     Business days of the warehouse.
          #     If not set, will be Monday to Friday by default.
          class Warehouse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The latest time of day that an order can be accepted and begin processing.
          # Later orders will be processed in the next day. The time is based on the
          # warehouse postal code.
          # @!attribute [rw] hour
          #   @return [::Integer]
          #     Required. Hour of the cutoff time until which an order has to be placed to
          #     be processed in the same day by the warehouse. Hour is based on the
          #     timezone of warehouse.
          # @!attribute [rw] minute
          #   @return [::Integer]
          #     Required. Minute of the cutoff time until which an order has to be placed
          #     to be processed in the same day by the warehouse. Minute is based on the
          #     timezone of warehouse.
          class WarehouseCutoffTime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Shipping address of the warehouse.
          # @!attribute [rw] street_address
          #   @return [::String]
          #     Street-level part of the address. For example: `111w 31st Street`.
          # @!attribute [rw] city
          #   @return [::String]
          #     Required. City, town or commune. May also include dependent localities or
          #     sublocalities (For example neighborhoods or suburbs).
          # @!attribute [rw] administrative_area
          #   @return [::String]
          #     Required. Top-level administrative subdivision of the country. For example,
          #     a state like California ("CA") or a province like Quebec ("QC").
          # @!attribute [rw] postal_code
          #   @return [::String]
          #     Required. Postal code or ZIP (For example "94043").
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Required. [CLDR country
          #     code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml)
          #     (For example "US").
          class Address
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Time spent in various aspects from order to the delivery of the product.
          # @!attribute [rw] min_transit_days
          #   @return [::Integer]
          #     Minimum number of business days that is spent in transit. 0 means same
          #     day delivery, 1 means next day delivery.
          #     Either `min_transit_days`, `max_transit_days` or
          #     `transit_time_table` must be set, but not both.
          # @!attribute [rw] max_transit_days
          #   @return [::Integer]
          #     Maximum number of business days that is spent in transit. 0 means same
          #     day delivery, 1 means next day delivery. Must be greater than or equal
          #     to `min_transit_days`.
          # @!attribute [rw] cutoff_time
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::CutoffTime]
          #     Business days cutoff time definition.
          #     If not configured the cutoff time will be defaulted to 8AM PST.
          # @!attribute [rw] min_handling_days
          #   @return [::Integer]
          #     Minimum number of business days spent before an order is shipped.
          #     0 means same day shipped, 1 means next day shipped.
          #     'min_handling_days' and 'max_handling_days' should be either set or not set
          #     at the same time.
          # @!attribute [rw] max_handling_days
          #   @return [::Integer]
          #     Maximum number of business days spent before an order is shipped.
          #     0 means same day shipped, 1 means next day shipped.
          #     Must be greater than or equal to `min_handling_days`.
          #     'min_handling_days' and 'max_handling_days' should be either set or not set
          #     at the same time.
          # @!attribute [rw] transit_time_table
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::TransitTable]
          #     Transit time table, number of business days spent in transit based on row
          #     and column dimensions. Either `min_transit_days`, `max_transit_days` or
          #     `transit_time_table` can be set, but not both.
          # @!attribute [rw] handling_business_day_config
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessDayConfig]
          #     The business days during which orders can be handled.
          #     If not provided, Monday to Friday business days will be assumed.
          # @!attribute [rw] transit_business_day_config
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessDayConfig]
          #     The business days during which orders can be in-transit.
          #     If not provided, Monday to Friday business days will be assumed.
          # @!attribute [rw] warehouse_based_delivery_times
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::WarehouseBasedDeliveryTime>]
          #     Optional. Indicates that the delivery time should be calculated per
          #     warehouse (shipping origin location) based on the settings of the selected
          #     carrier. When set, no other transit time related field in [delivery
          #     time][[google.shopping.content.bundles.ShippingSetting.DeliveryTime] should
          #     be set.
          class DeliveryTime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Business days cutoff time definition.
          # @!attribute [rw] hour
          #   @return [::Integer]
          #     Required. Hour of the cutoff time until which an order has to be placed to
          #     be processed in the same day.
          # @!attribute [rw] minute
          #   @return [::Integer]
          #     Required. Minute of the cutoff time until which an order has to be placed
          #     to be processed in the same day.
          # @!attribute [rw] time_zone
          #   @return [::String]
          #     Required. [Timezone
          #     identifier](https://developers.google.com/adwords/api/docs/appendix/codes-formats#timezone-ids)
          #     For example "Europe/Zurich".
          class CutoffTime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Business days of the warehouse.
          # @!attribute [rw] business_days
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::BusinessDayConfig::Weekday>]
          #     Required. Regular business days.
          #     May not be empty.
          class BusinessDayConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            module Weekday
              WEEKDAY_UNSPECIFIED = 0

              MONDAY = 1

              TUESDAY = 2

              WEDNESDAY = 3

              THURSDAY = 4

              FRIDAY = 5

              SATURDAY = 6

              SUNDAY = 7
            end
          end

          # Indicates that the delivery time should be calculated per warehouse
          # (shipping origin location) based on the settings of the selected carrier.
          # When set, no other transit time related field in `delivery_time` should be
          # set.
          # @!attribute [rw] carrier
          #   @return [::String]
          #     Required. Carrier, such as `"UPS"` or `"Fedex"`.
          # @!attribute [rw] carrier_service
          #   @return [::String]
          #     Required. Carrier service, such as `"ground"` or `"2 days"`. The name of
          #     the service must be in the eddSupportedServices list.
          # @!attribute [rw] warehouse
          #   @return [::String]
          #     Required. Warehouse name. This should match
          #     [warehouse][ShippingSetting.warehouses.name]
          class WarehouseBasedDeliveryTime
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Shipping rate group definitions. Only the last one is allowed to have an
          # empty `applicable_shipping_labels`, which means
          # "everything else". The other `applicable_shipping_labels` must
          # not overlap.
          # @!attribute [rw] applicable_shipping_labels
          #   @return [::Array<::String>]
          #     Required. A list of [shipping
          #     labels](https://support.google.com/merchants/answer/6324504) defining the
          #     products to which this rate group applies to. This is a disjunction: only
          #     one of the labels has to match for the rate group to apply. May only be
          #     empty for the last rate group of a service.
          # @!attribute [rw] single_value
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Value]
          #     The value of the rate group (For example flat rate $10). Can only be set
          #     if `main_table` and `subtables` are not set.
          # @!attribute [rw] main_table
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Table]
          #     A table defining the rate group, when `single_value` is not
          #     expressive enough. Can only be set if `single_value` is not
          #     set.
          # @!attribute [rw] subtables
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Table>]
          #     Optional. A list of subtables referred to by `main_table`. Can only
          #     be set if `main_table` is set.
          # @!attribute [rw] carrier_rates
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::CarrierRate>]
          #     Optional. A list of carrier rates that can be referred to by
          #     `main_table` or `single_value`.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. Name of the rate group.
          #     If set has to be unique within shipping service.
          class RateGroup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A table defining the rate group, when `single_value` is not
          # expressive enough.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the table. Required for subtables, ignored for the main table.
          # @!attribute [rw] row_headers
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Headers]
          #     Required. Headers of the table's rows.
          # @!attribute [rw] column_headers
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Headers]
          #     Headers of the table's columns. Optional: if not set then the table has
          #     only one dimension.
          # @!attribute [rw] rows
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Row>]
          #     Required. The list of rows that constitute the table. Must have the same
          #     length as `row_headers`.
          class Table
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Transit time table, number of business days spent in transit based on row
          # and column dimensions. Either `min_transit_days`, `max_transit_days` or
          # `transit_time_table` can be set, but not both.
          # @!attribute [rw] postal_code_group_names
          #   @return [::Array<::String>]
          #     Required. A list of region names
          #     {::Google::Shopping::Merchant::Accounts::V1beta::Region#name Region.name} . The
          #     last value can be
          #     `"all other locations"`. Example:
          #     `["zone 1", "zone 2", "all other locations"]`. The referred
          #     postal code groups must match the delivery country of the service.
          # @!attribute [rw] transit_time_labels
          #   @return [::Array<::String>]
          #     Required. A list of transit time labels. The last value can be
          #     `"all other labels"`. Example:
          #     `["food", "electronics", "all other labels"]`.
          # @!attribute [rw] rows
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::TransitTable::TransitTimeRow>]
          #     Required. If there's only one dimension set of `postal_code_group_names` or
          #     `transit_time_labels`, there are multiple rows each with one value
          #     for that dimension. If there are two dimensions, each row corresponds to a
          #     `postal_code_group_names`, and columns (values) to a
          #     `transit_time_labels`.
          class TransitTable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # If there's only one dimension set of `postal_code_group_names` or
            # `transit_time_labels`, there are multiple rows each with one value
            # for that dimension. If there are two dimensions, each row corresponds to a
            # `postal_code_group_names`, and columns (values) to a
            # `transit_time_labels`.
            # @!attribute [rw] values
            #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::TransitTable::TransitTimeRow::TransitTimeValue>]
            #     Required. Transit time range (min-max) in business days.
            class TransitTimeRow
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Transit time range (min-max) in business days.
              # @!attribute [rw] min_transit_days
              #   @return [::Integer]
              #     Minimum transit time range in business days. 0 means same
              #     day delivery, 1 means next day delivery.
              # @!attribute [rw] max_transit_days
              #   @return [::Integer]
              #     Must be greater than or equal to `min_transit_days`.
              class TransitTimeValue
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # Table of per store minimum order values for the pickup fulfillment type.
          # @!attribute [rw] store_code_set_with_movs
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::MinimumOrderValueTable::StoreCodeSetWithMov>]
          #     Required. A list of store code sets sharing the same minimum order value
          #     (MOV). At least two sets are required and the last one must be empty, which
          #     signifies 'MOV for all other stores'. Each store code can only appear once
          #     across all the sets. All prices within a service must have the same
          #     currency.
          class MinimumOrderValueTable
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A list of store code sets sharing the same minimum order value. At least
            # two sets are required and the last one must be empty, which signifies
            # 'MOV for all other stores'.
            # Each store code can only appear once across all the sets.
            # All prices within a service must have the same currency.
            # @!attribute [rw] store_codes
            #   @return [::Array<::String>]
            #     Optional. A list of unique store codes or empty for the catch all.
            # @!attribute [rw] value
            #   @return [::Google::Shopping::Type::Price]
            #     The minimum order value for the given stores.
            class StoreCodeSetWithMov
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A non-empty list of row or column headers for a table.
          # Exactly one of `prices`, `weights`,
          # `num_items`, `postal_code_group_names`, or
          # `location` must be set.
          # @!attribute [rw] prices
          #   @return [::Array<::Google::Shopping::Type::Price>]
          #     Required. A list of inclusive order price upper bounds. The last price's
          #     value can be infinity by setting price amount_micros = -1. For example
          #     `[{"amount_micros": 10000000, "currency_code": "USD"},
          #     \\{"amount_micros": 500000000, "currency_code": "USD"},
          #     \\{"amount_micros": -1, "currency_code": "USD"}]` represents the headers
          #     "<= $10", "<= $500", and "> $500". All prices within a service must have
          #     the same currency. Must be non-empty. Must be positive except -1. Can only
          #     be set if all other fields are not set.
          # @!attribute [rw] weights
          #   @return [::Array<::Google::Shopping::Type::Weight>]
          #     Required. A list of inclusive order weight upper bounds. The last weight's
          #     value can be infinity by setting price amount_micros = -1. For example
          #     `[{"amount_micros": 10000000, "unit": "kg"}, {"amount_micros": 50000000,
          #     "unit": "kg"},
          #     \\{"amount_micros": -1, "unit": "kg"}]` represents the headers
          #     "<= 10kg", "<= 50kg", and "> 50kg". All weights within a service must have
          #     the same unit. Must be non-empty. Must be positive except -1. Can only be
          #     set if all other fields are not set.
          # @!attribute [rw] number_of_items
          #   @return [::Array<::String>]
          #     Required. A list of inclusive number of items upper bounds. The last value
          #     can be
          #     `"infinity"`. For example
          #     `["10", "50", "infinity"]` represents the headers
          #     "<= 10 items", "<= 50 items", and "> 50 items". Must be non-empty. Can
          #     only be set if all other fields are not set.
          # @!attribute [rw] postal_code_group_names
          #   @return [::Array<::String>]
          #     Required. A list of postal group names. The last value can be
          #     `"all other locations"`. Example:
          #     `["zone 1", "zone 2", "all other locations"]`. The referred
          #     postal code groups must match the delivery country of the service. Must
          #     be non-empty. Can only be set if all other fields are not set.
          # @!attribute [rw] locations
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::LocationIdSet>]
          #     Required. A list of location ID sets. Must be non-empty. Can only be set if
          #     all other fields are not set.
          class Headers
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A list of location ID sets. Must be non-empty. Can only be set if all
          # other fields are not set.
          # @!attribute [rw] location_ids
          #   @return [::Array<::String>]
          #     Required. A non-empty list of
          #     [location
          #     IDs](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
          #     They must all be of the same location type (For
          #     example, state).
          class LocationIdSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Include a list of cells.
          # @!attribute [rw] cells
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::Value>]
          #     Required. The list of cells that constitute the row. Must have the same
          #     length as `columnHeaders` for two-dimensional tables, a length of 1 for
          #     one-dimensional tables.
          class Row
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The single value of a rate group or the value of a rate group table's cell.
          # Exactly one of `no_shipping`, `flat_rate`,
          # `price_percentage`, `carrier_rateName`,
          # `subtable_name` must be set.
          # @!attribute [rw] no_shipping
          #   @return [::Boolean]
          #     If true, then the product can't be shipped. Must be true when set, can only
          #     be set if all other fields are not set.
          # @!attribute [rw] flat_rate
          #   @return [::Google::Shopping::Type::Price]
          #     A flat rate. Can only be set if all other fields are not set.
          # @!attribute [rw] price_percentage
          #   @return [::String]
          #     A percentage of the price represented as a number in decimal notation
          #     (For example, `"5.4"`). Can only be set if all other fields are not
          #     set.
          # @!attribute [rw] carrier_rate
          #   @return [::String]
          #     The name of a carrier rate referring to a carrier rate defined in the
          #     same rate group. Can only be set if all other fields are not set.
          # @!attribute [rw] subtable
          #   @return [::String]
          #     The name of a subtable. Can only be set in table cells (For example, not
          #     for single values), and only if all other fields are not set.
          class Value
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A list of carrier rates that can be referred to by
          # `main_table` or `single_value`.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Name of the carrier rate. Must be unique per rate group.
          # @!attribute [rw] carrier
          #   @return [::String]
          #     Required. Carrier service, such as `"UPS"` or `"Fedex"`.
          # @!attribute [rw] carrier_service
          #   @return [::String]
          #     Required. Carrier service, such as `"ground"` or `"2 days"`.
          # @!attribute [rw] origin_postal_code
          #   @return [::String]
          #     Required. Shipping origin for this carrier rate.
          # @!attribute [rw] percentage_adjustment
          #   @return [::String]
          #     Optional. Multiplicative shipping rate modifier as a number in decimal
          #     notation. Can be negative. For example `"5.4"` increases the rate by 5.4%,
          #     `"-3"` decreases the rate by 3%.
          # @!attribute [rw] flat_adjustment
          #   @return [::Google::Shopping::Type::Price]
          #     Optional. Additive shipping rate modifier. Can be negative. For example
          #     `{ "amount_micros": 1, "currency_code" : "USD" }` adds $1 to the rate,
          #     `{ "amount_micros": -3, "currency_code" : "USD" }` removes $3 from the
          #     rate.
          class CarrierRate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetShippingSetting` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the shipping setting to retrieve.
          #     Format: `accounts/{account}/shippingsetting`
          class GetShippingSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `InsertShippingSetting` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account where this product will be inserted.
          #     Format: accounts/\\{account}
          # @!attribute [rw] shipping_setting
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::ShippingSettings]
          #     Required. The new version of the account.
          class InsertShippingSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
