# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Request message for the `GetOnlineReturnPolicy` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the return policy to retrieve.
          #     Format: `accounts/{account}/onlineReturnPolicies/{return_policy}`
          class GetOnlineReturnPolicyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `CreateOnlineReturnPolicy` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account for which the return policy will be created.
          #     Format: `accounts/{account}`
          # @!attribute [rw] online_return_policy
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy]
          #     Required. The return policy object to create.
          class CreateOnlineReturnPolicyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateOnlineReturnPolicy` method. The method
          # supports field masks and when the mask is provided, only the fields specified
          # in the mask are updated.
          # @!attribute [rw] online_return_policy
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy]
          #     Required. The online return policy to update.
          #     The online return policy's `name` field is used to identify the
          #     online return policy to be updated.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. List of fields being updated.
          #
          #     The following fields are supported (in both `snake_case` and
          #     `lowerCamelCase`):
          #
          #     - `accept_defective_only`
          #     - `accept_exchange`
          #     - `item_conditions`
          #     - `policy`
          #     - `process_refund_days`
          #     - `restocking_fee`
          #     - `return_methods`
          #     - `return_policy_uri`
          #     - `return_shipping_fee`
          class UpdateOnlineReturnPolicyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `DeleteOnlineReturnPolicy` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the return policy to delete.
          #     Format: `accounts/{account}/onlineReturnPolicies/{return_policy}`
          class DeleteOnlineReturnPolicyRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListOnlineReturnPolicies` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The merchant account for which to list return policies.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of `OnlineReturnPolicy` resources to return.
          #     The service returns fewer than this value if the number of return policies
          #     for the given merchant is less that than the `pageSize`. The default value
          #     is 10. The maximum value is 100; If a value higher than the maximum is
          #     specified, then the `pageSize` will default to the maximum
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListOnlineReturnPolicies`
          #     call. Provide the page token to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to
          #     `ListOnlineReturnPolicies` must match the call that provided the page
          #     token. The token returned as
          #     {::Google::Shopping::Merchant::Accounts::V1beta::ListOnlineReturnPoliciesResponse#next_page_token nextPageToken}
          #     in the response to the previous request.
          class ListOnlineReturnPoliciesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListOnlineReturnPolicies` method.
          # @!attribute [rw] online_return_policies
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy>]
          #     The retrieved return policies.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `pageToken` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListOnlineReturnPoliciesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # [Online return policy](https://support.google.com/merchants/answer/10220642)
          # object. This is currently used to represent return policies for ads and free
          # listings programs.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the `OnlineReturnPolicy` resource.
          #     Format: `accounts/{account}/onlineReturnPolicies/{return_policy}`
          # @!attribute [r] return_policy_id
          #   @return [::String]
          #     Output only. Return policy ID generated by Google.
          # @!attribute [rw] label
          #   @return [::String]
          #     Required. Immutable. This field represents the unique user-defined label of
          #     the return policy. It is important to note that the same label cannot be
          #     used in different return policies for the same country. Unless a product
          #     specifies a specific label attribute, policies will be automatically
          #     labeled as 'default'. To assign a custom return policy to certain product
          #     groups, follow the instructions provided in the [Return policy label]
          #     (https://support.google.com/merchants/answer/9445425).
          #     The label can contain up to 50 characters.
          # @!attribute [rw] countries
          #   @return [::Array<::String>]
          #     Required. Immutable. The countries of sale where the return policy applies.
          #     The values must be a valid 2 letter ISO 3166 code.
          # @!attribute [rw] policy
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::Policy]
          #     Optional. The return policy.
          # @!attribute [rw] seasonal_overrides
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::SeasonalOverride>]
          #     Optional. Overrides to the general policy for orders placed during a
          #     specific set of time intervals.
          # @!attribute [rw] restocking_fee
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::RestockingFee]
          #     Optional. The restocking fee that applies to all return reason categories.
          #     This would be treated as a free restocking fee if the value is not set.
          # @!attribute [rw] return_methods
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::ReturnMethod>]
          #     Optional. The return methods of how customers can return an item. This
          #     value is required to not be empty unless the type of return policy is
          #     noReturns.
          # @!attribute [rw] item_conditions
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::ItemCondition>]
          #     Optional. The item conditions accepted for returns must not be empty unless
          #     the type of return policy is 'noReturns'.
          # @!attribute [rw] return_shipping_fee
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::ReturnShippingFee]
          #     Optional. The return shipping fee. Should be set only when customer need to
          #     download and print the return label.
          # @!attribute [rw] return_policy_uri
          #   @return [::String]
          #     Required. The return policy uri. This can used by Google to do a sanity
          #     check for the policy. It must be a valid URL.
          # @!attribute [rw] accept_defective_only
          #   @return [::Boolean]
          #     Optional. This field specifies if merchant
          #     only accepts defective products for returns.
          # @!attribute [rw] process_refund_days
          #   @return [::Integer]
          #     Optional. The field specifies the number of
          #     days it takes for merchants to process refunds.
          # @!attribute [rw] accept_exchange
          #   @return [::Boolean]
          #     Optional. This field specifies if merchant
          #     allows customers to exchange products.
          # @!attribute [rw] return_label_source
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::ReturnLabelSource]
          #     Optional. The field specifies the return
          #     label source.
          class OnlineReturnPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The return shipping fee. This can either be a fixed fee or a boolean to
            # indicate that the customer pays the actual shipping cost.
            # @!attribute [rw] type
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::ReturnShippingFee::Type]
            #     Required. Type of return shipping fee.
            # @!attribute [rw] fixed_fee
            #   @return [::Google::Shopping::Type::Price]
            #     Fixed return shipping fee amount. This value is only applicable when type
            #     is `FIXED`. We will treat the return shipping fee as free if type is
            #     `FIXED` and this value is not set.
            class ReturnShippingFee
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Return shipping fee types.
              module Type
                # Default value. This value is unused.
                TYPE_UNSPECIFIED = 0

                # The return shipping fee is a fixed value.
                FIXED = 1

                # Customers will pay the actual return shipping fee.
                CUSTOMER_PAYING_ACTUAL_FEE = 2
              end
            end

            # The restocking fee. This can be a flat fee or a micro percent.
            # @!attribute [rw] fixed_fee
            #   @return [::Google::Shopping::Type::Price]
            #     Fixed restocking fee.
            #
            #     Note: The following fields are mutually exclusive: `fixed_fee`, `micro_percent`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] micro_percent
            #   @return [::Integer]
            #     Percent of total price in micros. 15,000,000 means 15% of the total
            #     price would be charged.
            #
            #     Note: The following fields are mutually exclusive: `micro_percent`, `fixed_fee`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class RestockingFee
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The available policies.
            # @!attribute [rw] type
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::OnlineReturnPolicy::Policy::Type]
            #     Policy type.
            # @!attribute [rw] days
            #   @return [::Integer]
            #     The number of days items can be returned after delivery, where one day
            #     is defined as 24 hours after the delivery timestamp. Required for
            #     `NUMBER_OF_DAYS_AFTER_DELIVERY` returns.
            class Policy
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Return policy types.
              module Type
                # Default value. This value is unused.
                TYPE_UNSPECIFIED = 0

                # The number of days within which a return is valid after delivery.
                NUMBER_OF_DAYS_AFTER_DELIVERY = 1

                # No returns.
                NO_RETURNS = 2

                # Life time returns.
                LIFETIME_RETURNS = 3
              end
            end

            # @!attribute [rw] return_days
            #   @return [::Integer]
            #     Number of days (from the delivery date) that the product can be
            #     returned.
            #
            #     Note: The following fields are mutually exclusive: `return_days`, `return_until_date`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] return_until_date
            #   @return [::Google::Type::Date]
            #     Fixed end date until which the product can be returned.
            #
            #     Note: The following fields are mutually exclusive: `return_until_date`, `return_days`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] label
            #   @return [::String]
            #     Required. Display name of this seasonal override in Merchant Center.
            # @!attribute [rw] start_date
            #   @return [::Google::Type::Date]
            #     Required. Defines the date range when this seasonal override applies.
            #     Both start_date and end_date are inclusive.
            #     The dates of the seasonal overrides should not overlap.
            # @!attribute [rw] end_date
            #   @return [::Google::Type::Date]
            #     Required. seasonal override end date (inclusive).
            class SeasonalOverride
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The available return methods.
            module ReturnMethod
              # Default value. This value is unused.
              RETURN_METHOD_UNSPECIFIED = 0

              # Return by mail.
              BY_MAIL = 1

              # Return in store.
              IN_STORE = 2

              # Return at a kiosk.
              AT_A_KIOSK = 3
            end

            # The available item conditions.
            module ItemCondition
              # Default value. This value is unused.
              ITEM_CONDITION_UNSPECIFIED = 0

              # New.
              NEW = 1

              # Used.
              USED = 2
            end

            # The available return label sources.
            module ReturnLabelSource
              # Default value. This value is unused.
              RETURN_LABEL_SOURCE_UNSPECIFIED = 0

              # Download and print.
              DOWNLOAD_AND_PRINT = 1

              # Label include in the package.
              IN_THE_PACKAGE = 2

              # Customer to provide.
              CUSTOMER_RESPONSIBILITY = 3
            end
          end
        end
      end
    end
  end
end
