# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Collection of information related to a Local Feed Partnership (LFP) provider.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the LFP provider.
          #     Format:
          #     `accounts/{account}/omnichannelSettings/{omnichannel_setting}/lfpProviders/{lfp_provider}`
          # @!attribute [r] region_code
          #   @return [::String]
          #     Output only. Region code defined by [CLDR](https://cldr.unicode.org/).
          # @!attribute [rw] display_name
          #   @return [::String]
          #     The display name of the LFP provider.
          class LfpProvider
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the FindLfpProviders method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the parent resource under which the LFP providers are
          #     found. Format:
          #     `accounts/{account}/omnichannelSettings/{omnichannel_setting}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of `LfpProvider` resources to return. The
          #     service returns fewer than this value if the number of lfp providers is
          #     less that than the `pageSize`. The default value is 50. The maximum value
          #     is 1000; If a value higher than the maximum is specified, then the
          #     `pageSize` will default to the maximum.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `FindLfpProviders` call.
          #     Provide the page token to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `FindLfpProviders` must
          #     match the call that provided the page token.
          class FindLfpProvidersRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the FindLfpProviders method.
          # @!attribute [rw] lfp_providers
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::LfpProvider>]
          #     The LFP providers from the specified merchant in the specified country.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class FindLfpProvidersResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the LinkLfpProvider method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the LFP provider resource to link.
          #     Format:
          #     `accounts/{account}/omnichannelSettings/{omnichannel_setting}/lfpProviders/{lfp_provider}`.
          #     The `lfp_provider` is the LFP provider ID.
          # @!attribute [rw] external_account_id
          #   @return [::String]
          #     Required. The external account ID by which this merchant is known to the
          #     LFP provider.
          class LinkLfpProviderRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the LinkLfpProvider method.
          # @!attribute [rw] response
          #   @return [::Google::Protobuf::Empty]
          #     Empty response.
          class LinkLfpProviderResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
