# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # A store's homepage.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the store's homepage.
          #     Format: `accounts/{account}/homepage`
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. The URI (typically a URL) of the store's homepage.
          # @!attribute [r] claimed
          #   @return [::Boolean]
          #     Output only. Whether the homepage is claimed. See
          #     https://support.google.com/merchants/answer/176793.
          class Homepage
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetHomepage` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the homepage to retrieve.
          #     Format: `accounts/{account}/homepage`
          class GetHomepageRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateHomepage` method.
          # @!attribute [rw] homepage
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::Homepage]
          #     Required. The new version of the homepage.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateHomepageRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ClaimHomepage` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the homepage to claim.
          #     Format: `accounts/{account}/homepage`
          class ClaimHomepageRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UnclaimHomepage` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the homepage to unclaim.
          #     Format: `accounts/{account}/homepage`
          class UnclaimHomepageRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
