# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Collection of information related to a Google Business Profile (GBP) account.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the GBP account. Format:
          #     `accounts/{account}/gbpAccount/{gbp_account}`
          # @!attribute [rw] gbp_account_id
          #   @return [::String]
          #     The id of the GBP account.
          # @!attribute [rw] type
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::GbpAccount::Type]
          #     The type of the Business Profile.
          # @!attribute [rw] gbp_account_name
          #   @return [::String]
          #     The name of the Business Profile.
          #     For personal accounts: Email id of the owner.
          #     For Business accounts: Name of the Business Account.
          # @!attribute [rw] listing_count
          #   @return [::Integer]
          #     Number of listings under this account.
          class GbpAccount
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of the GBP account.
            module Type
              # Default value. This value is unused.
              TYPE_UNSPECIFIED = 0

              # The GBP account is a user account.
              USER = 1

              # The GBP account is a business account.
              BUSINESS_ACCOUNT = 2
            end
          end

          # Request message for the ListGbpAccounts method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the parent resource under which the GBP accounts are
          #     listed. Format: `accounts/{account}`.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of `GbpAccount` resources to return. The
          #     service returns fewer than this value if the number of gbp accounts is less
          #     that than the `pageSize`. The default value is 50. The maximum value is
          #     1000; If a value higher than the maximum is specified, then the `pageSize`
          #     will default to the maximum.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListGbpAccounts` call.
          #     Provide the page token to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListGbpAccounts` must
          #     match the call that provided the page token.
          class ListGbpAccountsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListGbpAccounts method.
          # @!attribute [rw] gbp_accounts
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::GbpAccount>]
          #     The GBP accounts from the specified merchant in the specified country.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListGbpAccountsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the LinkGbpAccount method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the parent resource to which the GBP account is
          #     linked. Format: `accounts/{account}`.
          # @!attribute [rw] gbp_email
          #   @return [::String]
          #     Required. The email address of the Business Profile account.
          class LinkGbpAccountRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the LinkGbpAccount method.
          # @!attribute [rw] response
          #   @return [::Google::Protobuf::Empty]
          #     Empty response.
          class LinkGbpAccountResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
