# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # The categories of notifications the user opted into / opted out of. The email
          # preferences do not include mandatory announcements as users can't opt out of
          # them.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the EmailPreferences. The endpoint is only
          #     supported for the authenticated user.
          # @!attribute [rw] news_and_tips
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::EmailPreferences::OptInState]
          #     Optional. Updates on new features, tips and best practices.
          class EmailPreferences
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Opt in state of the email preference.
            module OptInState
              # Opt-in status is not specified.
              OPT_IN_STATE_UNSPECIFIED = 0

              # User has opted out of receiving this type of email.
              OPTED_OUT = 1

              # User has opted in to receiving this type of email.
              OPTED_IN = 2

              # User has opted in to receiving this type of email and the confirmation
              # email has been sent, but user has not yet confirmed the opt in (applies
              # only to certain countries).
              UNCONFIRMED = 3
            end
          end

          # Request message for GetEmailPreferences method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the `EmailPreferences` resource.
          #     Format: `accounts/{account}/users/{email}/emailPreferences`
          class GetEmailPreferencesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for UpdateEmailPreferences method.
          # @!attribute [rw] email_preferences
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::EmailPreferences]
          #     Required. Email Preferences to be updated.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateEmailPreferencesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
