# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Collection of information related to the [identity of a
          # business](https://support.google.com/merchants/answer/12564247).
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the business identity.
          #     Format: `accounts/{account}/businessIdentity`
          # @!attribute [rw] promotions_consent
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::PromotionsConsent]
          #     Optional. Whether the identity attributes may be used for promotions.
          # @!attribute [rw] black_owned
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute]
          #     Optional. Specifies whether the business identifies itself as being
          #     black-owned. This optional field will only be available for merchants with
          #     a business country set to `US`. It is also not applicable for marketplaces
          #     or marketplace sellers.
          # @!attribute [rw] women_owned
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute]
          #     Optional. Specifies whether the business identifies itself as being
          #     women-owned. This optional field will only be available for merchants with
          #     a business country set to `US`. It is also not applicable for marketplaces
          #     or marketplace sellers.
          # @!attribute [rw] veteran_owned
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute]
          #     Optional. Specifies whether the business identifies itself as being
          #     veteran-owned. This optional field will only be available for merchants
          #     with a business country set to `US`. It is also not applicable for
          #     marketplaces or marketplace sellers.
          # @!attribute [rw] latino_owned
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute]
          #     Optional. Specifies whether the business identifies itself as being
          #     latino-owned. This optional field will only be available for merchants with
          #     a business country set to `US`. It is also not applicable for marketplaces
          #     or marketplace sellers.
          # @!attribute [rw] small_business
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute]
          #     Optional. Specifies whether the business identifies itself as a small
          #     business. This optional field will only be available for merchants with a
          #     business country set to `US`. It is also not applicable for marketplaces.
          class BusinessIdentity
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # All information related to an identity attribute.
            # @!attribute [rw] identity_declaration
            #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity::IdentityAttribute::IdentityDeclaration]
            #     Required. The declaration of identity for this attribute.
            class IdentityAttribute
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # All possible settings regarding the declaration of an identity.
              module IdentityDeclaration
                # Default value indicating that no selection was made.
                IDENTITY_DECLARATION_UNSPECIFIED = 0

                # Indicates that the account identifies with the attribute.
                SELF_IDENTIFIES_AS = 1

                # Indicates that the account does not identify with the attribute.
                DOES_NOT_SELF_IDENTIFY_AS = 2
              end
            end

            # All possible settings regarding promotions related to the business
            # identity.
            module PromotionsConsent
              # Default value indicating that no selection was made.
              PROMOTIONS_CONSENT_UNSPECIFIED = 0

              # Indicates that the account consented to having their business identity
              # used for promotions.
              PROMOTIONS_CONSENT_GIVEN = 1

              # Indicates that the account did not consent to having their business
              # identity used for promotions.
              PROMOTIONS_CONSENT_DENIED = 2
            end
          end

          # Request message for the `GetBusinessIdentity` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the business identity.
          #     Format: `accounts/{account}/businessIdentity`
          class GetBusinessIdentityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateBusinessIdentity` method.
          # @!attribute [rw] business_identity
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::BusinessIdentity]
          #     Required. The new version of the business identity.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateBusinessIdentityRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
