# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # Collection of information related to the
          # [autofeed](https://support.google.com/merchants/answer/7538732) settings.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the autofeed settings.
          #     Format: `accounts/{account}/autofeedSettings`.
          # @!attribute [rw] enable_products
          #   @return [::Boolean]
          #     Required. Enables or disables product crawling through the autofeed for the
          #     given account. Autofeed accounts must meet [certain
          #     conditions](https://support.google.com/merchants/answer/7538732#Configure_automated_feeds_Standard_Experience),
          #     which can be checked through the `eligible` field.
          #     The account must **not** be a marketplace.
          #     When the autofeed is enabled for the first time, the products usually
          #     appear instantly. When re-enabling, it might take up to 24 hours for
          #     products to appear.
          # @!attribute [r] eligible
          #   @return [::Boolean]
          #     Output only. Determines whether merchant is eligible for being enrolled
          #     into an autofeed.
          class AutofeedSettings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetAutofeedSettings` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the autofeed settings.
          #     Format: `accounts/{account}/autofeedSettings`
          class GetAutofeedSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateAutofeedSettings` method.
          # @!attribute [rw] autofeed_settings
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::AutofeedSettings]
          #     Required. The new version of the autofeed setting.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. List of fields being updated.
          class UpdateAutofeedSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
