# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          # The tax settings of a merchant account. All methods require the admin role.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The name of the tax setting.
          #     Format:
          #     "\\{account_tax.name=accounts/\\{account}}"
          # @!attribute [r] account
          #   @return [::Integer]
          #     Output only. The ID of the account to which these account tax settings
          #     belong.
          # @!attribute [rw] tax_rules
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::TaxRule>]
          #     Tax rules. "Define the tax rules in each region.
          #     No tax will be presented if a region has no rule."
          class AccountTax
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to get tax settings
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name from which tax settings will be retrieved
          class GetAccountTaxRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to update the tax settings
          # @!attribute [rw] account_tax
          #   @return [::Google::Shopping::Merchant::Accounts::V1beta::AccountTax]
          #     Required. The tax setting that will be updated
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     The list of fields to be updated
          class UpdateAccountTaxRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to list all sub-account tax settings only for the requesting merchant
          # This method can only be called on a multi-client account, otherwise it'll
          # return an error.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent, which owns this collection of account tax.
          #     Format: accounts/\\{account}
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     The maximum number of tax settings to return in the response, used for
          #     paging.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     The token returned by the previous request.
          class ListAccountTaxRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response to account tax list request
          # This method can only be called on a multi-client account, otherwise it'll
          # return an error.
          # @!attribute [rw] account_taxes
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1beta::AccountTax>]
          #     Page of accounttax settings
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     The token for the retrieval of the next page of account tax settings.
          class ListAccountTaxResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
