# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/accounts/v1beta/homepage.proto for package 'google.shopping.merchant.accounts.v1beta'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/accounts/v1beta/homepage_pb'

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          module HomepageService
            # Service to support an API for a store's homepage.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.accounts.v1beta.HomepageService'

              # Retrieves a store's homepage.
              rpc :GetHomepage, ::Google::Shopping::Merchant::Accounts::V1beta::GetHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Homepage
              # Updates a store's homepage. Executing this method requires admin access.
              rpc :UpdateHomepage, ::Google::Shopping::Merchant::Accounts::V1beta::UpdateHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Homepage
              # Claims a store's homepage. Executing this method requires admin access.
              #
              # If the homepage is already claimed, this will recheck the
              # verification (unless the merchant is exempted from claiming, which also
              # exempts from verification) and return a successful response. If ownership
              # can no longer be verified, it will return an error, but it won't clear the
              # claim. In case of failure, a canonical error message will be returned:
              #    * PERMISSION_DENIED: user doesn't have the necessary permissions on this
              #    MC account;
              #    * FAILED_PRECONDITION:
              #      - The account is not a Merchant Center account;
              #      - MC account doesn't have a homepage;
              #      - claiming failed (in this case the error message will contain more
              #      details).
              rpc :ClaimHomepage, ::Google::Shopping::Merchant::Accounts::V1beta::ClaimHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Homepage
              # Unclaims a store's homepage. Executing this method requires admin access.
              rpc :UnclaimHomepage, ::Google::Shopping::Merchant::Accounts::V1beta::UnclaimHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Homepage
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
