# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/accounts/v1beta/accounts.proto for package 'google.shopping.merchant.accounts.v1beta'
# Original file comments:
# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/accounts/v1beta/accounts_pb'

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1beta
          module AccountsService
            # Service to support Accounts API.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.accounts.v1beta.AccountsService'

              # Retrieves an account from your Merchant Center account.
              # After inserting, updating, or deleting an account, it may take several
              # minutes before changes take effect.
              rpc :GetAccount, ::Google::Shopping::Merchant::Accounts::V1beta::GetAccountRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Account
              # Creates a standalone Merchant Center account with additional configuration.
              # Adds the user that makes the request as an admin for the new account.
              rpc :CreateAndConfigureAccount, ::Google::Shopping::Merchant::Accounts::V1beta::CreateAndConfigureAccountRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Account
              # Deletes the specified account regardless of its type: standalone, MCA or
              # sub-account. Deleting an MCA leads to the deletion of all of its
              # sub-accounts. Executing this method requires admin access.
              # The deletion succeeds only if the account does not provide services
              # to any other account and has no processed offers. You can use the `force`
              # parameter to override this.
              rpc :DeleteAccount, ::Google::Shopping::Merchant::Accounts::V1beta::DeleteAccountRequest, ::Google::Protobuf::Empty
              # Updates an account regardless of its type: standalone, MCA or sub-account.
              # Executing this method requires admin access.
              rpc :UpdateAccount, ::Google::Shopping::Merchant::Accounts::V1beta::UpdateAccountRequest, ::Google::Shopping::Merchant::Accounts::V1beta::Account
              # Lists accounts accessible to the calling user and matching the
              # constraints of the request such as page size or filters.
              # This is not just listing the sub-accounts of an MCA, but all accounts the
              # calling user has access to including other MCAs, linked accounts,
              # standalone accounts and so on. If no filter is provided, then it returns
              # accounts the user is directly added to.
              rpc :ListAccounts, ::Google::Shopping::Merchant::Accounts::V1beta::ListAccountsRequest, ::Google::Shopping::Merchant::Accounts::V1beta::ListAccountsResponse
              # List all sub-accounts for a given multi client account. This is a
              # convenience wrapper for the more powerful `ListAccounts` method. This
              # method will produce the same results as calling `ListsAccounts` with the
              # following filter:
              # `relationship(providerId={parent} AND service(type="ACCOUNT_AGGREGATION"))`
              rpc :ListSubAccounts, ::Google::Shopping::Merchant::Accounts::V1beta::ListSubAccountsRequest, ::Google::Shopping::Merchant::Accounts::V1beta::ListSubAccountsResponse
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
