# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1/termsofservice_pb"
require "google/shopping/merchant/accounts/v1/terms_of_service_service"

class ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_terms_of_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::TermsOfService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_terms_of_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_terms_of_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::GetTermsOfServiceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_terms_of_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_terms_of_service({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_terms_of_service name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_terms_of_service ::Google::Shopping::Merchant::Accounts::V1::GetTermsOfServiceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_terms_of_service({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_terms_of_service(::Google::Shopping::Merchant::Accounts::V1::GetTermsOfServiceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_terms_of_service_client_stub.call_rpc_count
    end
  end

  def test_retrieve_latest_terms_of_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::TermsOfService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    region_code = "hello world"
    kind = :TERMS_OF_SERVICE_KIND_UNSPECIFIED

    retrieve_latest_terms_of_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_latest_terms_of_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RetrieveLatestTermsOfServiceRequest, request
      assert_equal "hello world", request["region_code"]
      assert_equal :TERMS_OF_SERVICE_KIND_UNSPECIFIED, request["kind"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_latest_terms_of_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_latest_terms_of_service({ region_code: region_code, kind: kind }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_latest_terms_of_service region_code: region_code, kind: kind do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_latest_terms_of_service ::Google::Shopping::Merchant::Accounts::V1::RetrieveLatestTermsOfServiceRequest.new(region_code: region_code, kind: kind) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_latest_terms_of_service({ region_code: region_code, kind: kind }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_latest_terms_of_service(::Google::Shopping::Merchant::Accounts::V1::RetrieveLatestTermsOfServiceRequest.new(region_code: region_code, kind: kind), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_latest_terms_of_service_client_stub.call_rpc_count
    end
  end

  def test_accept_terms_of_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::AcceptTermsOfServiceResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    account = "hello world"
    region_code = "hello world"

    accept_terms_of_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :accept_terms_of_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::AcceptTermsOfServiceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["account"]
      assert_equal "hello world", request["region_code"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, accept_terms_of_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.accept_terms_of_service({ name: name, account: account, region_code: region_code }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.accept_terms_of_service name: name, account: account, region_code: region_code do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.accept_terms_of_service ::Google::Shopping::Merchant::Accounts::V1::AcceptTermsOfServiceRequest.new(name: name, account: account, region_code: region_code) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.accept_terms_of_service({ name: name, account: account, region_code: region_code }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.accept_terms_of_service(::Google::Shopping::Merchant::Accounts::V1::AcceptTermsOfServiceRequest.new(name: name, account: account, region_code: region_code), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, accept_terms_of_service_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
