# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1/regions_pb"
require "google/shopping/merchant/accounts/v1/regions_service"

class ::Google::Shopping::Merchant::Accounts::V1::RegionsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_region
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_region_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_region, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::GetRegionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_region_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_region({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_region name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_region ::Google::Shopping::Merchant::Accounts::V1::GetRegionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_region({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_region(::Google::Shopping::Merchant::Accounts::V1::GetRegionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_region_client_stub.call_rpc_count
    end
  end

  def test_create_region
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    region_id = "hello world"
    region = {}

    create_region_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_region, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["region_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1::Region), request["region"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_region_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_region({ parent: parent, region_id: region_id, region: region }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_region parent: parent, region_id: region_id, region: region do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_region ::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest.new(parent: parent, region_id: region_id, region: region) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_region({ parent: parent, region_id: region_id, region: region }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_region(::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest.new(parent: parent, region_id: region_id, region: region), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_region_client_stub.call_rpc_count
    end
  end

  def test_batch_create_regions
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_regions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_regions, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_regions_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_regions({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_regions parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_regions ::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_regions({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_regions(::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_regions_client_stub.call_rpc_count
    end
  end

  def test_update_region
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    region = {}
    update_mask = {}

    update_region_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_region, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1::Region), request["region"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_region_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_region({ region: region, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_region region: region, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_region ::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest.new(region: region, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_region({ region: region, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_region(::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest.new(region: region, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_region_client_stub.call_rpc_count
    end
  end

  def test_batch_update_regions
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_regions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_update_regions, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_update_regions_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_update_regions({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_update_regions parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_update_regions ::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_update_regions({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_update_regions(::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_update_regions_client_stub.call_rpc_count
    end
  end

  def test_delete_region
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_region_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_region, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_region_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_region({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_region name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_region ::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_region({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_region(::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_region_client_stub.call_rpc_count
    end
  end

  def test_batch_delete_regions
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_delete_regions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_delete_regions, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::BatchDeleteRegionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_delete_regions_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_delete_regions({ parent: parent, requests: requests }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_delete_regions parent: parent, requests: requests do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_delete_regions ::Google::Shopping::Merchant::Accounts::V1::BatchDeleteRegionsRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_delete_regions({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_delete_regions(::Google::Shopping::Merchant::Accounts::V1::BatchDeleteRegionsRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_delete_regions_client_stub.call_rpc_count
    end
  end

  def test_list_regions
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::ListRegionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_regions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_regions, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::ListRegionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_regions_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_regions({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_regions parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_regions ::Google::Shopping::Merchant::Accounts::V1::ListRegionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_regions({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_regions(::Google::Shopping::Merchant::Accounts::V1::ListRegionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_regions_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
