# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/shopping/merchant/accounts/v1/regions_pb"
require "google/shopping/merchant/accounts/v1/regions_service/rest"


class ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_region
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_region_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_get_region_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_region_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_region({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_region name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_region ::Google::Shopping::Merchant::Accounts::V1::GetRegionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_region({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_region(::Google::Shopping::Merchant::Accounts::V1::GetRegionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_region_client_stub.call_count
      end
    end
  end

  def test_create_region
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    region_id = "hello world"
    region = {}

    create_region_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_create_region_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_region_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_region({ parent: parent, region_id: region_id, region: region }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_region parent: parent, region_id: region_id, region: region do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_region ::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest.new(parent: parent, region_id: region_id, region: region) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_region({ parent: parent, region_id: region_id, region: region }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_region(::Google::Shopping::Merchant::Accounts::V1::CreateRegionRequest.new(parent: parent, region_id: region_id, region: region), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_region_client_stub.call_count
      end
    end
  end

  def test_batch_create_regions
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_regions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_batch_create_regions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_regions_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_regions({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_regions parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_regions ::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_regions({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_regions(::Google::Shopping::Merchant::Accounts::V1::BatchCreateRegionsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_regions_client_stub.call_count
      end
    end
  end

  def test_update_region
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::Region.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    region = {}
    update_mask = {}

    update_region_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_update_region_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_region_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_region({ region: region, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_region region: region, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_region ::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest.new(region: region, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_region({ region: region, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_region(::Google::Shopping::Merchant::Accounts::V1::UpdateRegionRequest.new(region: region, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_region_client_stub.call_count
      end
    end
  end

  def test_batch_update_regions
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_update_regions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_batch_update_regions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_update_regions_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_update_regions({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_update_regions parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_update_regions ::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_update_regions({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_update_regions(::Google::Shopping::Merchant::Accounts::V1::BatchUpdateRegionsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_update_regions_client_stub.call_count
      end
    end
  end

  def test_delete_region
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_region_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_delete_region_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_region_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_region({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_region name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_region ::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_region({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_region(::Google::Shopping::Merchant::Accounts::V1::DeleteRegionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_region_client_stub.call_count
      end
    end
  end

  def test_batch_delete_regions
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_delete_regions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_batch_delete_regions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_regions_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_regions({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_regions parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_regions ::Google::Shopping::Merchant::Accounts::V1::BatchDeleteRegionsRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_regions({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_regions(::Google::Shopping::Merchant::Accounts::V1::BatchDeleteRegionsRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_regions_client_stub.call_count
      end
    end
  end

  def test_list_regions
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::ListRegionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_regions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::ServiceStub.stub :transcode_list_regions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_regions_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_regions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_regions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_regions ::Google::Shopping::Merchant::Accounts::V1::ListRegionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_regions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_regions(::Google::Shopping::Merchant::Accounts::V1::ListRegionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_regions_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RegionsService::Rest::Client::Configuration, config
  end
end
