# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1/developerregistration_pb"
require "google/shopping/merchant/accounts/v1/developer_registration_service"

class ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_register_gcp
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistration.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    developer_email = "hello world"

    register_gcp_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :register_gcp, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RegisterGcpRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["developer_email"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, register_gcp_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.register_gcp({ name: name, developer_email: developer_email }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.register_gcp name: name, developer_email: developer_email do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.register_gcp ::Google::Shopping::Merchant::Accounts::V1::RegisterGcpRequest.new(name: name, developer_email: developer_email) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.register_gcp({ name: name, developer_email: developer_email }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.register_gcp(::Google::Shopping::Merchant::Accounts::V1::RegisterGcpRequest.new(name: name, developer_email: developer_email), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, register_gcp_client_stub.call_rpc_count
    end
  end

  def test_get_developer_registration
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistration.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_developer_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_developer_registration, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::GetDeveloperRegistrationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_developer_registration_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_developer_registration({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_developer_registration name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_developer_registration ::Google::Shopping::Merchant::Accounts::V1::GetDeveloperRegistrationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_developer_registration({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_developer_registration(::Google::Shopping::Merchant::Accounts::V1::GetDeveloperRegistrationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_developer_registration_client_stub.call_rpc_count
    end
  end

  def test_unregister_gcp
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    unregister_gcp_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :unregister_gcp, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::UnregisterGcpRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, unregister_gcp_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.unregister_gcp({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.unregister_gcp name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.unregister_gcp ::Google::Shopping::Merchant::Accounts::V1::UnregisterGcpRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.unregister_gcp({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.unregister_gcp(::Google::Shopping::Merchant::Accounts::V1::UnregisterGcpRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, unregister_gcp_client_stub.call_rpc_count
    end
  end

  def test_get_account_for_gcp_registration
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::GetAccountForGcpRegistrationResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.

    get_account_for_gcp_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_account_for_gcp_registration, name
      assert_kind_of ::Google::Protobuf::Empty, request
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_account_for_gcp_registration_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_account_for_gcp_registration({  }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_account_for_gcp_registration ::Google::Protobuf::Empty.new() do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_account_for_gcp_registration({  }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_account_for_gcp_registration(::Google::Protobuf::Empty.new(), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 4, get_account_for_gcp_registration_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::DeveloperRegistrationService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
