# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/merchant/accounts/v1/accountservices_pb"
require "google/shopping/merchant/accounts/v1/account_services_service"

class ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_account_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_account_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_account_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_account_service({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_account_service name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_account_service ::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_account_service({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_account_service(::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_account_service_client_stub.call_rpc_count
    end
  end

  def test_list_account_services
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_account_services_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_account_services, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["page_token"]
      assert_equal 42, request["page_size"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_account_services_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_account_services({ parent: parent, page_token: page_token, page_size: page_size }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_account_services parent: parent, page_token: page_token, page_size: page_size do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_account_services ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_account_services({ parent: parent, page_token: page_token, page_size: page_size }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_account_services(::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest.new(parent: parent, page_token: page_token, page_size: page_size), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_account_services_client_stub.call_rpc_count
    end
  end

  def test_propose_account_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provider = "hello world"
    account_service = {}

    propose_account_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :propose_account_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["provider"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Merchant::Accounts::V1::AccountService), request["account_service"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, propose_account_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.propose_account_service({ parent: parent, provider: provider, account_service: account_service }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.propose_account_service parent: parent, provider: provider, account_service: account_service do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.propose_account_service ::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest.new(parent: parent, provider: provider, account_service: account_service) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.propose_account_service({ parent: parent, provider: provider, account_service: account_service }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.propose_account_service(::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest.new(parent: parent, provider: provider, account_service: account_service), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, propose_account_service_client_stub.call_rpc_count
    end
  end

  def test_approve_account_service
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_account_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_account_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_account_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_account_service({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_account_service name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_account_service ::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_account_service({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_account_service(::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_account_service_client_stub.call_rpc_count
    end
  end

  def test_reject_account_service
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reject_account_service_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reject_account_service, name
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reject_account_service_client_stub do
      # Create client
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reject_account_service({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reject_account_service name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reject_account_service ::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reject_account_service({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reject_account_service(::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reject_account_service_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
