# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/shopping/merchant/accounts/v1/accountservices_pb"
require "google/shopping/merchant/accounts/v1/account_services_service/rest"


class ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_account_service
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_account_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ServiceStub.stub :transcode_get_account_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_account_service_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_account_service({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_account_service name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_account_service ::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_account_service({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_account_service(::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_account_service_client_stub.call_count
      end
    end
  end

  def test_list_account_services
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_token = "hello world"
    page_size = 42

    list_account_services_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ServiceStub.stub :transcode_list_account_services_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_account_services_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_account_services({ parent: parent, page_token: page_token, page_size: page_size }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_account_services parent: parent, page_token: page_token, page_size: page_size do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_account_services ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest.new(parent: parent, page_token: page_token, page_size: page_size) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_account_services({ parent: parent, page_token: page_token, page_size: page_size }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_account_services(::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest.new(parent: parent, page_token: page_token, page_size: page_size), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_account_services_client_stub.call_count
      end
    end
  end

  def test_propose_account_service
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    provider = "hello world"
    account_service = {}

    propose_account_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ServiceStub.stub :transcode_propose_account_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, propose_account_service_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.propose_account_service({ parent: parent, provider: provider, account_service: account_service }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.propose_account_service parent: parent, provider: provider, account_service: account_service do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.propose_account_service ::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest.new(parent: parent, provider: provider, account_service: account_service) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.propose_account_service({ parent: parent, provider: provider, account_service: account_service }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.propose_account_service(::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest.new(parent: parent, provider: provider, account_service: account_service), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, propose_account_service_client_stub.call_count
      end
    end
  end

  def test_approve_account_service
    # Create test objects.
    client_result = ::Google::Shopping::Merchant::Accounts::V1::AccountService.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    approve_account_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ServiceStub.stub :transcode_approve_account_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_account_service_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_account_service({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_account_service name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_account_service ::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_account_service({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_account_service(::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_account_service_client_stub.call_count
      end
    end
  end

  def test_reject_account_service
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    reject_account_service_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::ServiceStub.stub :transcode_reject_account_service_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reject_account_service_client_stub do
        # Create client
        client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reject_account_service({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reject_account_service name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reject_account_service ::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reject_account_service({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reject_account_service(::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reject_account_service_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Rest::Client::Configuration, config
  end
end
