# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Type
    # Represents a whole or partial calendar date, such as a birthday. The time of
    # day and time zone are either specified elsewhere or are insignificant. The
    # date is relative to the Gregorian Calendar. This can represent one of the
    # following:
    #
    # * A full date, with non-zero year, month, and day values
    # * A month and day value, with a zero year, such as an anniversary
    # * A year on its own, with zero month and day values
    # * A year and month value, with a zero day, such as a credit card expiration
    # date
    #
    # Related types are [google.type.TimeOfDay][google.type.TimeOfDay] and
    # `google.protobuf.Timestamp`.
    # @!attribute [rw] year
    #   @return [::Integer]
    #     Year of the date. Must be from 1 to 9999, or 0 to specify a date without
    #     a year.
    # @!attribute [rw] month
    #   @return [::Integer]
    #     Month of a year. Must be from 1 to 12, or 0 to specify a year without a
    #     month and day.
    # @!attribute [rw] day
    #   @return [::Integer]
    #     Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
    #     to specify a year by itself or a year and month where the day isn't
    #     significant.
    class Date
      include ::Google::Protobuf::MessageExts
      extend ::Google::Protobuf::MessageExts::ClassMethods
    end
  end
end
