# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # This resource represents the agreement state for a given account and terms of
          # service kind.
          # The state is as follows:
          #
          # * If the business has accepted a terms of service,
          # {::Google::Shopping::Merchant::Accounts::V1::Accepted `accepted`}
          # will be populated, otherwise it will be empty
          # * If the business must sign a terms of service,
          # {::Google::Shopping::Merchant::Accounts::V1::Required `required`}
          # will be populated, otherwise it will be empty.
          #
          # Note that both `required` and `accepted` can be present. In this case the
          # `accepted` terms of services will have an expiration date set in the
          # {::Google::Shopping::Merchant::Accounts::V1::Accepted#valid_until `valid_until`}
          # field. The `required` terms of services need to be accepted before
          # `valid_until` in order for the account to continue having a valid agreement.
          # When accepting new terms of services we expect third-party providers to
          # display the text associated with the given terms of service agreement (the
          # url to the file containing the text is added in the Required message below as
          # {::Google::Shopping::Merchant::Accounts::V1::Required#tos_file_uri `tos_file_uri`}).
          # The actual acceptance of the terms of service is done by calling accept on
          # the
          # {::Google::Shopping::Merchant::Accounts::V1::Accepted#terms_of_service `TermsOfService`}
          # resource.
          # `valid_until` field.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the terms of service version.
          #     Format: `accounts/{account}/termsOfServiceAgreementState/{identifier}`
          #     The identifier format is:
          #     `{[TermsOfServiceKind][google.shopping.merchant.accounts.v1.TermsOfServiceKind]}-{country}`
          #     For example, an identifier could be: `MERCHANT_CENTER-EU` or
          #     `MERCHANT_CENTER-US`.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Required. Region code as defined by https://cldr.unicode.org/. This is the
          #     country the current state applies to.
          # @!attribute [rw] terms_of_service_kind
          #   @return [::Google::Shopping::Merchant::Accounts::V1::TermsOfServiceKind]
          #     Required. Terms of Service kind associated with the particular version.
          # @!attribute [rw] accepted
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Accepted]
          #     Optional. The accepted terms of service of this kind and for the associated
          #     region_code
          # @!attribute [rw] required
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Required]
          #     Optional. The required terms of service
          class TermsOfServiceAgreementState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes the [accepted terms of
          # service](https://developers.google.com/merchant/api/guides/accounts/create-and-configure#accept_the_merchant_center_terms_of_service).
          # @!attribute [rw] terms_of_service
          #   @return [::String]
          #     Required. The accepted
          #     {::Google::Shopping::Merchant::Accounts::V1::TermsOfService termsOfService}.
          # @!attribute [rw] accepted_by
          #   @return [::String]
          #     Required. The account where the acceptance was recorded. This can be the
          #     account itself or, in the case of subaccounts, the advanced account.
          # @!attribute [rw] valid_until
          #   @return [::Google::Type::Date]
          #     Optional. When set, it states that the accepted `TermsOfService` is only
          #     valid until the end of this date (in UTC). A new one must be accepted
          #     before then. The information of the required `TermsOfService` is found in
          #     the `Required` message.
          class Accepted
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Describes the terms of service which are required to be accepted.
          # @!attribute [rw] terms_of_service
          #   @return [::String]
          #     Required. The `TermsOfService` that need to be accepted.
          # @!attribute [rw] tos_file_uri
          #   @return [::String]
          #     Required. Full URL to the terms of service file. This field is the same as
          #     `TermsOfService.file_uri`, it is added here for convenience only.
          class Required
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetTermsOfServiceAgreementState` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the terms of service version.
          #     Format: `accounts/{account}/termsOfServiceAgreementStates/{identifier}`
          #     The identifier format is: `{TermsOfServiceKind}-{country}`
          class GetTermsOfServiceAgreementStateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `RetrieveForApplicationTermsOfServiceAgreementState`
          # method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The account for which to get a TermsOfServiceAgreementState
          #     Format: `accounts/{account}`
          class RetrieveForApplicationTermsOfServiceAgreementStateRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
