# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # Defines participation in a given program for the specified account.
          #
          # Programs provide a mechanism for adding functionality to a Merchant Center
          # accounts. A typical example of this is the [Free product
          # listings](https://support.google.com/merchants/answer/13889434)
          # program, which enables products from a business's store to be shown across
          # Google for free.
          #
          # The following list is the available set of program resource IDs accessible
          # through the API:
          #
          # * `checkout`
          # * `free-listings`
          # * `shopping-ads`
          # * `youtube-shopping-checkout`
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the program.
          #     Format: `accounts/{account}/programs/{program}`
          # @!attribute [r] documentation_uri
          #   @return [::String]
          #     Output only. The URL of a Merchant Center help page describing the program.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Program::State]
          #     Output only. The participation state of the account in the program.
          # @!attribute [r] active_region_codes
          #   @return [::Array<::String>]
          #     Output only. The regions in which the account is actively participating in
          #     the program. Active regions are defined as those where all program
          #     requirements affecting the regions have been met.
          #
          #     Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
          #     either a country where the program applies specifically to that country or
          #     `001` when the program applies globally.
          # @!attribute [r] unmet_requirements
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::Program::Requirement>]
          #     Output only. The requirements that the account has not yet satisfied that
          #     are affecting participation in the program.
          class Program
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines a requirement specified for participation in the program.
            # @!attribute [r] title
            #   @return [::String]
            #     Output only. Name of the requirement.
            # @!attribute [r] documentation_uri
            #   @return [::String]
            #     Output only. The URL of a help page describing the requirement.
            # @!attribute [r] affected_region_codes
            #   @return [::Array<::String>]
            #     Output only. The regions that are currently affected by this requirement
            #     not being met.
            #
            #     Region codes are defined by [CLDR](https://cldr.unicode.org/). This is
            #     either a country where the program applies specifically to that country
            #     or `001` when the program applies globally.
            class Requirement
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Possible program participation states for the account.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The account is not eligible to participate in the program.
              NOT_ELIGIBLE = 1

              # The account is eligible to participate in the program.
              ELIGIBLE = 2

              # The program is enabled for the account.
              ENABLED = 3
            end
          end

          # Request message for the GetProgram method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the program to retrieve.
          #     Format: `accounts/{account}/programs/{program}`. For example,
          #     `accounts/123456/programs/free-listings`.
          class GetProgramRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListPrograms method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The name of the account for which to retrieve all programs.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of programs to return in a single response. If
          #     unspecified (or 0), a default size of 1000 is used. The maximum value is
          #     1000; values above 1000 will be coerced to 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A continuation token, received from a previous `ListPrograms`
          #     call. Provide this to retrieve the next page.
          class ListProgramsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListPrograms method.
          # @!attribute [rw] programs
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::Program>]
          #     The programs for the given account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token that can be sent as `page_token` to retrieve the next page. If this
          #     field is omitted, there are no subsequent pages.
          class ListProgramsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the EnableProgram method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the program for which to enable participation for the
          #     given account. Format: `accounts/{account}/programs/{program}`. For
          #     example, `accounts/123456/programs/free-listings`.
          class EnableProgramRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the DisableProgram method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the program for which to disable participation for
          #     the given account. Format: `accounts/{account}/programs/{program}`. For
          #     example, `accounts/123456/programs/free-listings`.
          class DisableProgramRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
