# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # Collection of information related to the omnichannel settings of a merchant.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the omnichannel setting. Format:
          #     `accounts/{account}/omnichannelSettings/{omnichannel_setting}`
          # @!attribute [rw] region_code
          #   @return [::String]
          #     Required. Immutable. Region code defined by
          #     [CLDR](https://cldr.unicode.org/). Must be provided in the Create method,
          #     and is immutable.
          # @!attribute [rw] lsf_type
          #   @return [::Google::Shopping::Merchant::Accounts::V1::OmnichannelSetting::LsfType]
          #     Required. The Local Store Front type for this country.
          # @!attribute [rw] in_stock
          #   @return [::Google::Shopping::Merchant::Accounts::V1::InStock]
          #     Optional. The InStock URI and state for this country.
          # @!attribute [rw] pickup
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Pickup]
          #     Optional. The Pickup URI and state for this country.
          # @!attribute [r] lfp_link
          #   @return [::Google::Shopping::Merchant::Accounts::V1::LfpLink]
          #     Output only. The established link to a LFP provider.
          # @!attribute [rw] odo
          #   @return [::Google::Shopping::Merchant::Accounts::V1::OnDisplayToOrder]
          #     Optional. The On Display to Order (ODO) policy URI and state for this
          #     country.
          # @!attribute [rw] about
          #   @return [::Google::Shopping::Merchant::Accounts::V1::About]
          #     Optional. The about page URI and state for this country.
          # @!attribute [rw] inventory_verification
          #   @return [::Google::Shopping::Merchant::Accounts::V1::InventoryVerification]
          #     Optional. The inventory verification contact and state for this country.
          class OmnichannelSetting
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The product page experience type, which is also called the Local Store
            # Front (LSF) type. Check the [HC
            # article](https://support.google.com/merchants/answer/7178526) for more
            # details.
            module LsfType
              # Default value. This value is unused.
              LSF_TYPE_UNSPECIFIED = 0

              # Google-Hosted Local Store Front. Check the [HC
              # article](https://support.google.com/merchants/answer/14869424) for more
              # details.
              GHLSF = 1

              # Merchant-Hosted Local Store Front Basic. Check the [HC
              # article](https://support.google.com/merchants/answer/14615867) for more
              # details.
              MHLSF_BASIC = 2

              # Merchant-Hosted Local Store Front Full. Check the [HC
              # article](https://support.google.com/merchants/answer/14617076) for more
              # details.
              MHLSF_FULL = 3
            end
          end

          # The state of a omnichannel setting related review process.
          class ReviewState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the review process.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # The review process has concluded successfully. The reviewed item is
              # active.
              ACTIVE = 1

              # The review process failed.
              FAILED = 2

              # The review process is running.
              RUNNING = 3

              # The review process is waiting for the merchant to take action.
              ACTION_REQUIRED = 4
            end
          end

          # Collection of information related to InStock.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Optional. Product landing page URI. It is only used for the review of MHLSF
          #     in-stock serving. This URI domain should match with the business's
          #     homepage. Required to be empty if the lsf_type is GHLSF, and required when
          #     the lsf_type is MHLSF_FULL or MHLSF_BASIC.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the in-stock serving.
          class InStock
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of information related to Pickup.
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. Pickup product page URI. It is only used for the review of pickup
          #     serving. This URI domain should match with the business's homepage.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the pickup serving.
          class Pickup
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of information related to the LFP link.
          # @!attribute [rw] lfp_provider
          #   @return [::String]
          #     Required. The resource name of the LFP provider.
          #     Format: `lfpProviders/{lfp_provider}`
          # @!attribute [rw] external_account_id
          #   @return [::String]
          #     Required. The account ID by which this merchant is known to the LFP
          #     provider.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the LFP link.
          class LfpLink
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of information related to the on display to order
          # ([ODO](https://support.google.com/merchants/answer/14615056?ref_topic=15145747&sjid=6892280366904591178-NC)).
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. The on display to order (ODO) policy URI.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the URI.
          class OnDisplayToOrder
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of information related to the about page
          # ([impressum](https://support.google.com/merchants/answer/14675634?ref_topic=15145634&sjid=6892280366904591178-NC)).
          # @!attribute [rw] uri
          #   @return [::String]
          #     Required. The about page URI.
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the URI.
          class About
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Collection of information related to [inventory
          # verification](https://support.google.com/merchants/answer/14684499?ref_topic=15145634&sjid=6892280366904591178-NC).
          # @!attribute [r] state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::InventoryVerification::State]
          #     Output only. The state of the inventory verification process.
          # @!attribute [rw] contact
          #   @return [::String]
          #     Required. The name of the contact for the inventory verification process.
          # @!attribute [rw] contact_email
          #   @return [::String]
          #     Required. The email address of the contact for the inventory verification
          #     process.
          # @!attribute [r] contact_state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ReviewState::State]
          #     Output only. The state of the contact verification.
          class InventoryVerification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the [inventory
            # verification](https://support.google.com/merchants/answer/14684499?ref_topic=15145634&sjid=6892280366904591178-NC)
            # process.
            module State
              # Default value. This value is unused.
              STATE_UNSPECIFIED = 0

              # When the merchant needs to initiate the inventory
              # verification process. The next state is INACTIVE.
              ACTION_REQUIRED = 1

              # When the merchant is ready to request inventory verification.
              INACTIVE = 5

              # The inventory verification process is running. If the merchant is
              # rejected, the next state is INACTIVE.
              RUNNING = 2

              # The inventory verification process succeeded.
              SUCCEEDED = 3

              # When merchant fails the inventory verification process and all attempts
              # are exhausted.
              SUSPENDED = 4
            end
          end

          # Request message for the GetOmnichannelSettings method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the omnichannel setting to retrieve.
          #     Format: `accounts/{account}/omnichannelSettings/{omnichannel_setting}`
          class GetOmnichannelSettingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the ListOmnichannelSettings method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent, which owns this collection of omnichannel settings.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of omnichannel settings to return. The service
          #     may return fewer than this value. If unspecified, at most 50 omnichannel
          #     settings will be returned. The maximum value is 1000; values above 1000
          #     will be coerced to 1000.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListOmnichannelSettings`
          #     call. Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListOmnichannelSettings`
          #     must match the call that provided the page token.
          class ListOmnichannelSettingsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the ListOmnichannelSettings method.
          # @!attribute [rw] omnichannel_settings
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::OmnichannelSetting>]
          #     The omnichannel settings from the specified merchant.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListOmnichannelSettingsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the CreateOmnichannelSetting method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent resource where this omnichannel setting will be
          #     created. Format: `accounts/{account}`
          # @!attribute [rw] omnichannel_setting
          #   @return [::Google::Shopping::Merchant::Accounts::V1::OmnichannelSetting]
          #     Required. The omnichannel setting to create.
          class CreateOmnichannelSettingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the UpdateOmnichannelSetting method.
          # @!attribute [rw] omnichannel_setting
          #   @return [::Google::Shopping::Merchant::Accounts::V1::OmnichannelSetting]
          #     Required. The omnichannel setting to update.
          #
          #     The omnichannel setting's `name` field is used to identify the
          #     omnichannel setting to be updated.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Required. The list of fields to be updated.
          #
          #     The following fields are supported in snake_case only:
          #     - `lsf_type`
          #     - `in_stock`
          #     - `pickup`
          #     - `odo`
          #     - `about`
          #     - `inventory_verification`
          #
          #     Full replacement with wildcard `*`is supported, while empty/implied update
          #     mask is not.
          class UpdateOmnichannelSettingRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the RequestInventoryVerification method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the omnichannel setting to request inventory
          #     verification. Format:
          #     `accounts/{account}/omnichannelSettings/{omnichannel_setting}`
          class RequestInventoryVerificationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the RequestInventoryVerification method.
          # @!attribute [rw] omnichannel_setting
          #   @return [::Google::Shopping::Merchant::Accounts::V1::OmnichannelSetting]
          #     The omnichannel setting that was updated.
          class RequestInventoryVerificationResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
