# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # Represents a developer registration owned by a Merchant account.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The `name` (ID) of the developer registration. Generated by the
          #     Content API upon creation of a new `DeveloperRegistration`. The `account`
          #     represents the merchant ID of the merchant that owns the registration.
          # @!attribute [r] gcp_ids
          #   @return [::Array<::String>]
          #     Output only. The GCP ids attached to this developer registration
          class DeveloperRegistration
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the RegisterGCP method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the developer registration to be created for the
          #     merchant account that the GCP will be registered with. Format:
          #     `accounts/{account}/developerRegistration`
          # @!attribute [rw] developer_email
          #   @return [::String]
          #     Immutable. If the developer email provided is associated with a user in the
          #     merchant account provided, the user will be updated to have "API developer"
          #     access type and the email preference corresponding to that user will be
          #     updated to have the new "API notifications" preference. If the developer
          #     email provided is not associated with any user we will just add it as a
          #     contact. The email preference corresponding to that contact will have the
          #     new "API notifications" preference. Make sure the email used is associated
          #     with a Google Account (Google Workspace account or Gmail account)
          #     and is not a service account as service accounts can't receive emails.
          class RegisterGcpRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the UnregisterGCP method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the developer registration to be created for the
          #     merchant account that the GCP will be registered with. Format:
          #     `accounts/{account}/developerRegistration`
          class UnregisterGcpRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the GetDeveloperRegistration method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The `name` (ID) of the developer registration.
          class GetDeveloperRegistrationRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the GetAccountForGcpRegistration method.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the merchant account id that the GCP is registered with.
          class GetAccountForGcpRegistrationResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
