# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # The `BusinessInfo` message contains essential information about a
          #  business.
          #
          #  This message captures key business details such as physical address,
          #  customer service contacts, and region-specific identifiers.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the business info.
          #     Format: `accounts/{account}/businessInfo`
          # @!attribute [rw] address
          #   @return [::Google::Type::PostalAddress]
          #     Optional. The address of the business. Only `region_code`, `address_lines`,
          #     `postal_code`, `administrative_area` and `locality` fields are supported.
          #     All other fields are ignored.
          # @!attribute [r] phone
          #   @return [::Google::Type::PhoneNumber]
          #     Output only. The phone number of the business.
          # @!attribute [r] phone_verification_state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::PhoneVerificationState]
          #     Output only. The phone verification state of the business.
          # @!attribute [rw] customer_service
          #   @return [::Google::Shopping::Merchant::Accounts::V1::CustomerService]
          #     Optional. The customer service of the business.
          # @!attribute [rw] korean_business_registration_number
          #   @return [::String]
          #     Optional. The 10-digit [Korean business registration
          #     number](https://support.google.com/merchants/answer/9037766) separated with
          #     dashes in the format: XXX-XX-XXXXX.
          class BusinessInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetBusinessInfo` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the business info.
          #     Format: `accounts/{account}/businessInfo`. For example,
          #     `accounts/123456/businessInfo`.
          class GetBusinessInfoRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateBusinessInfo` method.
          # @!attribute [rw] business_info
          #   @return [::Google::Shopping::Merchant::Accounts::V1::BusinessInfo]
          #     Required. The new version of the business info.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. List of fields being updated.
          #
          #     The following fields are supported (in both `snake_case` and
          #     `lowerCamelCase`):
          #
          #     - `address`
          #     - `customer_service`
          #     - `korean_business_registration_number`
          class UpdateBusinessInfoRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
