# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # The `AccountService` message represents a specific service that a provider
          # account offers to a Merchant Center account.
          #
          # `AccountService` defines the permissions and capabilities granted to the
          # provider, allowing for operations such as product management or campaign
          # management.
          #
          # The lifecycle of an `AccountService` involves a proposal phase, where one
          # party suggests the service, and an approval phase, where the other party
          # accepts or rejects it. This handshake mechanism ensures mutual consent before
          # any access is granted. This mechanism safeguards both parties by ensuring
          # that access rights are granted appropriately and that both the business and
          # provider are aware of the services enabled. In scenarios where a user is an
          # admin of both accounts, the approval can happen automatically.
          #
          # The mutability of a service is also managed through `AccountService`. Some
          # services might be immutable, for example, if they were established through
          # other systems or APIs, and you cannot alter them through this API.
          # @!attribute [rw] products_management
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ProductsManagement]
          #     Service type for managing products. This allows the provider to handle
          #     product data on behalf of the business, including reading and writing
          #     product listings. It's commonly used when the provider offers inventory
          #     management or catalog synchronization services to keep the business's
          #     product information up-to-date across platforms.
          #
          #     Note: The following fields are mutually exclusive: `products_management`, `campaigns_management`, `account_management`, `account_aggregation`, `local_listing_management`, `comparison_shopping`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] campaigns_management
          #   @return [::Google::Shopping::Merchant::Accounts::V1::CampaignsManagement]
          #     Service type for managing advertising campaigns. Grants the provider
          #     access to create and manage the business's ad campaigns, including
          #     setting up campaigns, adjusting bids, and optimizing performance.
          #
          #     Note: The following fields are mutually exclusive: `campaigns_management`, `products_management`, `account_management`, `account_aggregation`, `local_listing_management`, `comparison_shopping`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] account_management
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountManagement]
          #     Service type for account management. Enables the provider to perform
          #     administrative actions on the business's account, such as
          #     configuring account settings, managing users, or updating business
          #     information.
          #
          #     Note: The following fields are mutually exclusive: `account_management`, `products_management`, `campaigns_management`, `account_aggregation`, `local_listing_management`, `comparison_shopping`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] account_aggregation
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountAggregation]
          #     Service type for account aggregation. This enables the provider, which is
          #     an advanced account, to manage multiple sub-accounts (client
          #     accounts). Through this service, the advanced account provider can
          #     perform administrative and operational tasks across all linked
          #     sub-accounts.
          #
          #     This is useful for agencies, aggregators, or large retailers that need
          #     centralized control over many Merchant Center accounts.
          #
          #     Note: The following fields are mutually exclusive: `account_aggregation`, `products_management`, `campaigns_management`, `account_management`, `local_listing_management`, `comparison_shopping`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] local_listing_management
          #   @return [::Google::Shopping::Merchant::Accounts::V1::LocalListingManagement]
          #     Service type for local listings management. The business group associated
          #     with the external account id will be used to provide local inventory to
          #     this Merchant Center account.
          #
          #     Note: The following fields are mutually exclusive: `local_listing_management`, `products_management`, `campaigns_management`, `account_management`, `account_aggregation`, `comparison_shopping`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] comparison_shopping
          #   @return [::Google::Shopping::Merchant::Accounts::V1::ComparisonShopping]
          #     Service type for comparison shopping. The provider is a CSS (Comparison
          #     Shopping Service) managing the account. See
          #     https://support.google.com/merchants/answer/12653197
          #
          #     Note: The following fields are mutually exclusive: `comparison_shopping`, `products_management`, `campaigns_management`, `account_management`, `account_aggregation`, `local_listing_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the account service.
          #     Format: `accounts/{account}/services/{service}`
          # @!attribute [r] provider
          #   @return [::String]
          #     Output only. The provider of the service. Either the reference to an
          #     account such as `providers/123` or a well-known service provider (one of
          #     `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
          # @!attribute [r] provider_display_name
          #   @return [::String]
          #     Output only. The human-readable display name of the provider account.
          # @!attribute [r] handshake
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Handshake]
          #     Output only. Information about the state of the service in terms of
          #     establishing it (e.g. is it pending approval or approved).
          # @!attribute [r] mutability
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountService::Mutability]
          #     Output only. Whether the service is mutable (e.g. through Approve / Reject
          #     RPCs). A service that was created through another system or API might be
          #     immutable.
          # @!attribute [rw] external_account_id
          #   @return [::String]
          #     Immutable. An optional, immutable identifier that Google uses to refer to
          #     this account when communicating with the provider. This should be the
          #     unique account ID within the provider's system (for example, your shop ID
          #     in Shopify).
          #
          #     If you have multiple accounts with the same provider - for instance,
          #     different accounts for various regions — the `external_account_id`
          #     differentiates between them, ensuring accurate linking and integration
          #     between Google and the provider.
          class AccountService
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The list of mutability option settings a service can have.
            module Mutability
              # Unused default value
              MUTABILITY_UNSPECIFIED = 0

              # The service can be mutated without restrictions.
              MUTABLE = 1

              # The service is read-only and must not be mutated.
              IMMUTABLE = 2
            end
          end

          # Request to get an account service.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the account service to get.
          #     Format: `accounts/{account}/services/{service}`
          class GetAccountServiceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to list account services.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent account of the account service to filter by.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. The token returned by the previous `list` request.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of elements to return in the response. Use for
          #     paging. If no `page_size` is specified, `100` is used as the default value.
          #     The maximum allowed value is `1000`.
          class ListAccountServicesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response after trying to list account services.
          # @!attribute [rw] account_services
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::AccountService>]
          #     The account services that match your filter.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A page token. You can send the `page_token` to get the next page.
          #     Only included in the `list` response if there are more pages.
          class ListAccountServicesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to propose an account service.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The resource name of the parent account for the service.
          #     Format: `accounts/{account}`
          # @!attribute [rw] provider
          #   @return [::String]
          #     Required. The provider of the service. Either the reference to an account
          #     such as `providers/123` or a well-known service provider (one of
          #     `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
          # @!attribute [rw] account_service
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountService]
          #     Required. The account service to propose.
          class ProposeAccountServiceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to approve an account service.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the account service to approve.
          #     Format: `accounts/{account}/services/{service}`
          class ApproveAccountServiceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to reject an account service.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the account service to reject.
          #     Format: `accounts/{account}/services/{service}`
          class RejectAccountServiceRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `ProductsManagement` payload.
          class ProductsManagement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `CampaignManagement` payload.
          class CampaignsManagement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `AccountManagement` payload.
          class AccountManagement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `AccountAggregation` payload.
          class AccountAggregation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `LocalListingManagement` payload.
          class LocalListingManagement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # `ComparisonShopping` payload.
          class ComparisonShopping
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The current status of establishing of the service.
          # (for example, pending approval or approved).
          # @!attribute [r] approval_state
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Handshake::ApprovalState]
          #     Output only. The approval state of this handshake.
          # @!attribute [r] actor
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Handshake::Actor]
          #     Output only. The most recent account to modify the account service's
          #     `approval_status`.
          class Handshake
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The approal state of a handshake.
            module ApprovalState
              # Unspecified approval status.
              APPROVAL_STATE_UNSPECIFIED = 0

              # The service was proposed and is waiting to be confirmed.
              PENDING = 1

              # Both parties have confirmed the service.
              ESTABLISHED = 2

              # The service proposal was rejected.
              REJECTED = 3
            end

            # The various actors that can be involved in a handshake.
            module Actor
              # Unspecified actor.
              ACTOR_UNSPECIFIED = 0

              # The last change was done by the account who has this service.
              ACCOUNT = 1

              # The last change was done by the other party who this service points to.
              OTHER_PARTY = 2
            end
          end
        end
      end
    end
  end
end
