# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # The `Account` message represents a business's account within Shopping
          # Ads. It's the primary entity for managing product data, settings, and
          # interactions with Google's services and external providers.
          #
          # Accounts can operate as standalone entities or be part of a advanced account
          # structure. In an advanced account setup the parent account manages multiple
          # sub-accounts.
          #
          # Establishing an account involves configuring attributes like the account
          # name, time zone, and language preferences.
          #
          # The `Account` message is the parent entity for many other resources, for
          # example, `AccountRelationship`, `Homepage`, `BusinessInfo` and so on.
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the account.
          #     Format: `accounts/{account}`
          # @!attribute [r] account_id
          #   @return [::Integer]
          #     Output only. The ID of the account.
          # @!attribute [rw] account_name
          #   @return [::String]
          #     Required. A human-readable name of the account. See
          #     [store name](https://support.google.com/merchants/answer/160556) and
          #     [business name](https://support.google.com/merchants/answer/12159159) for
          #     more information.
          # @!attribute [rw] adult_content
          #   @return [::Boolean]
          #     Optional. Whether this account contains adult content.
          # @!attribute [r] test_account
          #   @return [::Boolean]
          #     Output only. Whether this is a test account.
          # @!attribute [rw] time_zone
          #   @return [::Google::Type::TimeZone]
          #     Required. The time zone of the account.
          #
          #     On writes, `time_zone` sets both the `reporting_time_zone` and the
          #     `display_time_zone`.
          #
          #     For reads, `time_zone` always returns the `display_time_zone`. If
          #     `display_time_zone` doesn't exist for your account, `time_zone` is empty.
          #
          #     The `version` field is not supported, won't be set in responses and will be
          #     silently ignored if specified in requests.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Required. The account's [BCP-47 language
          #     code](https://tools.ietf.org/html/bcp47), such as `en-US` or `sr-Latn`.
          class Account
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `GetAccount` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the account to retrieve.
          #     Format: `accounts/{account}`
          class GetAccountRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `CreateAndConfigureAccount` method.
          # @!attribute [rw] account
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Account]
          #     Required. The account to be created.
          # @!attribute [rw] user
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::CreateAndConfigureAccountRequest::AddUser>]
          #     Optional. Users to be added to the account.
          # @!attribute [rw] service
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::CreateAndConfigureAccountRequest::AddAccountService>]
          #     Required. An account service between the account to be created and the
          #     provider account is initialized as part of the creation. At least one such
          #     service needs to be provided. Currently exactly one of these needs to be
          #     `account_aggregation` and `accounts.createAndConfigure` method can be
          #     used to create a sub-account under an existing advanced account through
          #     this method. Additional `account_management` or
          #     `product_management` services may be provided.
          # @!attribute [rw] set_alias
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::CreateAndConfigureAccountRequest::SetAliasForRelationship>]
          #     Optional. If a relationship is created with a provider, you can set an
          #     alias for it with this field. The calling user must be an admin on the
          #     provider to be able to set an alias.
          class CreateAndConfigureAccountRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Instruction for adding a user to the account during creation.
            # @!attribute [rw] user_id
            #   @return [::String]
            #     Required. The email address of the user (for example,
            #     `john.doe@gmail.com`).
            # @!attribute [rw] user
            #   @return [::Google::Shopping::Merchant::Accounts::V1::User]
            #     Optional. Details about the user to be added. At the moment, only access
            #     rights may be specified.
            # @!attribute [rw] verification_mail_settings
            #   @return [::Google::Shopping::Merchant::Accounts::V1::VerificationMailSettings]
            #     Optional. Settings related to configuring the verification email that is
            #     sent after adding a user.
            class AddUser
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Additional instructions to add account services during creation of the
            # account.
            # @!attribute [rw] account_aggregation
            #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountAggregation]
            #     The provider is an
            #     [aggregator](https://support.google.com/merchants/answer/188487) for
            #     the account. Payload for service type Account Aggregation.
            #
            #     Note: The following fields are mutually exclusive: `account_aggregation`, `account_management`, `comparison_shopping`, `products_management`, `campaigns_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] account_management
            #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountManagement]
            #     The provider manages this account. Payload for service type Account
            #     Management.
            #
            #     Note: The following fields are mutually exclusive: `account_management`, `account_aggregation`, `comparison_shopping`, `products_management`, `campaigns_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] comparison_shopping
            #   @return [::Google::Shopping::Merchant::Accounts::V1::ComparisonShopping]
            #     The provider is a CSS (Comparison Shopping Service) of this account.
            #     Payload for service type Comparison Shopping.
            #
            #     Note: The following fields are mutually exclusive: `comparison_shopping`, `account_aggregation`, `account_management`, `products_management`, `campaigns_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] products_management
            #   @return [::Google::Shopping::Merchant::Accounts::V1::ProductsManagement]
            #     The provider manages products for this account. Payload for service
            #     type products management.
            #
            #     Note: The following fields are mutually exclusive: `products_management`, `account_aggregation`, `account_management`, `comparison_shopping`, `campaigns_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] campaigns_management
            #   @return [::Google::Shopping::Merchant::Accounts::V1::CampaignsManagement]
            #     The provider manages campaigns for this account. Payload for service
            #     type campaigns management.
            #
            #     Note: The following fields are mutually exclusive: `campaigns_management`, `account_aggregation`, `account_management`, `comparison_shopping`, `products_management`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] provider
            #   @return [::String]
            #     Required. The provider of the service. Either the reference to an account
            #     such as `providers/123` or a well-known service provider (one of
            #     `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
            # @!attribute [rw] external_account_id
            #   @return [::String]
            #     Immutable. An optional, immutable identifier that Google uses to refer to
            #     this account when communicating with the provider. This should be the
            #     unique account ID within the provider's system (for example, your shop ID
            #     in Shopify).
            #
            #     If you have multiple accounts with the same provider - for instance,
            #     different accounts for various regions — the `external_account_id`
            #     differentiates between them, ensuring accurate linking and integration
            #     between Google and the provider.
            #
            #     The external account ID must be specified for the campaigns management
            #     service type.
            #
            #     The external account ID must not be specified for the account aggregation
            #     service type.
            #
            #     The external account ID is optional / may be specified for all other
            #     service types.
            class AddAccountService
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Set an alias for a relationship between a provider and the account to
            # be created.
            # @!attribute [rw] provider
            #   @return [::String]
            #     Required. The provider of the service. This is a reference to an account
            #     such as `providers/123` or `accounts/123`. The same provider must be
            #     specified in at least one of the `service` fields.
            # @!attribute [rw] account_id_alias
            #   @return [::String]
            #     Required. The unique ID of this account in the provider's system.
            #     The value must be unique across all accounts on the platform for this
            #     provider.
            class SetAliasForRelationship
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Request message for the `DeleteAccount` method.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the account to delete.
          #     Format: `accounts/{account}`
          # @!attribute [rw] force
          #   @return [::Boolean]
          #     Optional. If set to `true`, the account is deleted even if it provides
          #     services to other accounts or has processed offers.
          class DeleteAccountRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateAccount` method.
          # @!attribute [rw] account
          #   @return [::Google::Shopping::Merchant::Accounts::V1::Account]
          #     Required. The new version of the account.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. List of fields being updated.
          #
          #     The following fields are supported (in both `snake_case` and
          #     `lowerCamelCase`):
          #
          #     - `account_name`
          #     - `adult_content`
          #     - `language_code`
          #     - `time_zone`
          class UpdateAccountRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `accounts.list` method.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of accounts to return. The service may return
          #     fewer than this value.  If unspecified, at most 250 accounts are returned.
          #     The maximum value is 500; values above 500 are coerced to 500.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `accounts.list` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided in the `accounts.list`
          #     request must match the call that provided the page token.
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Returns only accounts that match the
          #     [filter](https://developers.google.com/merchant/api/guides/accounts/filter).
          #     For more details, see the
          #     [filter syntax
          #     reference](https://developers.google.com/merchant/api/guides/accounts/filter-syntax).
          class ListAccountsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `accounts.list` method.
          # @!attribute [rw] accounts
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::Account>]
          #     The accounts matching the `ListAccountsRequest`.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListAccountsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `ListSubAccounts` method.
          # @!attribute [rw] provider
          #   @return [::String]
          #     Required. The aggregation service provider.
          #     Format: `accounts/{accountId}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of accounts to return. The service may return
          #     fewer than this value.  If unspecified, at most 250 accounts are returned.
          #     The maximum value is 500; values above 500 are coerced to 500.
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `accounts.list` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided in the `accounts.list`
          #     request must match the call that provided the page token.
          class ListSubAccountsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListSubAccounts` method.
          # @!attribute [rw] accounts
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::Account>]
          #     The accounts for which the given parent account is an aggregator.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListSubAccountsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
