# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # The `AccountRelationship` message defines a formal connection between a
          # merchant's account and a service provider's account. This relationship
          # enables the provider to offer specific services to the business, such as
          # product management or campaign management. It specifies the access rights
          # and permissions to the business's data relevant to those services.
          #
          # Establishing an account relationship involves linking the merchant's account
          # with a provider's account. The provider could be another Google account (like
          # Google Ads or Google My Business) or a third-party platform (such as Shopify
          # or WooCommerce).
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the account relationship.
          #     Format: `accounts/{account}/relationships/{relationship}`. For example,
          #     `accounts/123456/relationships/567890`.
          # @!attribute [rw] provider
          #   @return [::String]
          #     Immutable. The provider of the service. Either the reference to an account
          #     such as `providers/123` or a well-known service provider (one of
          #     `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
          # @!attribute [r] provider_display_name
          #   @return [::String]
          #     Output only. The human-readable display name of the provider account.
          # @!attribute [rw] account_id_alias
          #   @return [::String]
          #     Optional. An optional alias you can assign to this account relationship.
          #     This alias acts as a convenient identifier for your own reference and
          #     management. It must be unique among all your account relationships with the
          #     same provider.
          #
          #     For example, you might use `account_id_alias` to assign a friendly name
          #     to this relationship for easier identification in your systems.
          class AccountRelationship
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to get an account relationship.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The resource name of the account relationship to get.
          #     Format: `accounts/{account}/relationships/{relationship}`. For example,
          #     `accounts/123456/relationships/567890`.
          class GetAccountRelationshipRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request message for the `UpdateAccountRelationship` method.
          # @!attribute [rw] account_relationship
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountRelationship]
          #     Required. The new version of the account relationship.
          # @!attribute [rw] update_mask
          #   @return [::Google::Protobuf::FieldMask]
          #     Optional. List of fields being updated.
          #
          #     The following fields are supported (in both `snake_case` and
          #     `lowerCamelCase`):
          #
          #     - `account_id_alias`
          class UpdateAccountRelationshipRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Request to list account relationships.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent account of the account relationship to filter by.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. The token returned by the previous `list` request.
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of elements to return in the response. Use for
          #     paging. If no `page_size` is specified, `100` is used as the default value.
          #     The maximum allowed value is `1000`.
          class ListAccountRelationshipsRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response after trying to list account relationships.
          # @!attribute [rw] account_relationships
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::AccountRelationship>]
          #     The account relationships that match your filter.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A page token. You can send the `page_token` to get the next page.
          #     Only included in the `list` response if there are more pages.
          class ListAccountRelationshipsResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
