# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          # Issues with your Merchant Center account that can impact all your products.
          #  For more information, see [Account-level issues in Merchant
          #  Center](https://support.google.com/merchants/answer/12153802?sjid=17798438912526418908-EU#account).
          # @!attribute [rw] name
          #   @return [::String]
          #     Identifier. The resource name of the account issue.
          #     Format: `accounts/{account}/issues/{id}`. For example,
          #       `accounts/123456/issues/misrepresentation-of-self-or-products-unacceptable-business-practice-policy`.
          # @!attribute [rw] title
          #   @return [::String]
          #     The localized title of the issue.
          # @!attribute [rw] severity
          #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountIssue::Severity]
          #     The overall severity of the issue.
          # @!attribute [rw] impacted_destinations
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::AccountIssue::ImpactedDestination>]
          #     The impact this issue has on various destinations.
          # @!attribute [rw] detail
          #   @return [::String]
          #     Further localized details about the issue.
          # @!attribute [rw] documentation_uri
          #   @return [::String]
          #     Link to Merchant Center Help Center providing further information about the
          #     issue and how to fix it.
          class AccountIssue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The impact of the issue on a destination.
            # @!attribute [rw] reporting_context
            #   @return [::Google::Shopping::Type::ReportingContext::ReportingContextEnum]
            #     The impacted reporting context.
            # @!attribute [rw] impacts
            #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::AccountIssue::ImpactedDestination::Impact>]
            #     The (negative) impact for various regions on the given destination.
            class ImpactedDestination
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The impact of the issue on a region.
              # @!attribute [rw] region_code
              #   @return [::String]
              #     The [CLDR region code](https://cldr.unicode.org/) where this issue
              #     applies.
              # @!attribute [rw] severity
              #   @return [::Google::Shopping::Merchant::Accounts::V1::AccountIssue::Severity]
              #     The severity of the issue on the destination and region.
              class Impact
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end

            # All possible issue severities.
            module Severity
              # The severity is unknown.
              SEVERITY_UNSPECIFIED = 0

              # The issue causes offers to not serve.
              CRITICAL = 1

              # The issue might affect offers (in the future) or might be an
              # indicator of issues with offers.
              ERROR = 2

              # The issue is a suggestion for improvement.
              SUGGESTION = 3
            end
          end

          # Request message for the `ListAccountIssues` method.
          # @!attribute [rw] parent
          #   @return [::String]
          #     Required. The parent, which owns this collection of issues.
          #     Format: `accounts/{account}`
          # @!attribute [rw] page_size
          #   @return [::Integer]
          #     Optional. The maximum number of issues to return. The service may return
          #     fewer than this value. If unspecified, at most 50 issues will be returned.
          #     The maximum value is 100; values above 100 will be coerced to 100
          # @!attribute [rw] page_token
          #   @return [::String]
          #     Optional. A page token, received from a previous `ListAccountIssues` call.
          #     Provide this to retrieve the subsequent page.
          #
          #     When paginating, all other parameters provided to `ListAccountIssues` must
          #     match the call that provided the page token.
          # @!attribute [rw] language_code
          #   @return [::String]
          #     Optional. The issues in the response will have human-readable fields in the
          #     given language. The format is [BCP-47](https://tools.ietf.org/html/bcp47),
          #     such as `en-US` or `sr-Latn`. If not value is provided, `en-US` will be
          #     used.
          # @!attribute [rw] time_zone
          #   @return [::String]
          #     Optional. The [IANA](https://www.iana.org/time-zones) timezone used to
          #     localize times in human-readable fields. For example 'America/Los_Angeles'.
          #     If not set, 'America/Los_Angeles' will be used.
          class ListAccountIssuesRequest
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Response message for the `ListAccountIssues` method.
          # @!attribute [rw] account_issues
          #   @return [::Array<::Google::Shopping::Merchant::Accounts::V1::AccountIssue>]
          #     The issues from the specified account.
          # @!attribute [rw] next_page_token
          #   @return [::String]
          #     A token, which can be sent as `page_token` to retrieve the next page.
          #     If this field is omitted, there are no subsequent pages.
          class ListAccountIssuesResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
