# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          module LfpProvidersService
            # Path helper methods for the LfpProvidersService API.
            module Paths
              ##
              # Create a fully-qualified LfpProvider resource string.
              #
              # The resource will be in the following format:
              #
              # `accounts/{account}/omnichannelSettings/{omnichannel_setting}/lfpProviders/{lfp_provider}`
              #
              # @param account [String]
              # @param omnichannel_setting [String]
              # @param lfp_provider [String]
              #
              # @return [::String]
              def lfp_provider_path account:, omnichannel_setting:, lfp_provider:
                raise ::ArgumentError, "account cannot contain /" if account.to_s.include? "/"
                raise ::ArgumentError, "omnichannel_setting cannot contain /" if omnichannel_setting.to_s.include? "/"

                "accounts/#{account}/omnichannelSettings/#{omnichannel_setting}/lfpProviders/#{lfp_provider}"
              end

              ##
              # Create a fully-qualified OmnichannelSetting resource string.
              #
              # The resource will be in the following format:
              #
              # `accounts/{account}/omnichannelSettings/{omnichannel_setting}`
              #
              # @param account [String]
              # @param omnichannel_setting [String]
              #
              # @return [::String]
              def omnichannel_setting_path account:, omnichannel_setting:
                raise ::ArgumentError, "account cannot contain /" if account.to_s.include? "/"

                "accounts/#{account}/omnichannelSettings/#{omnichannel_setting}"
              end

              extend self
            end
          end
        end
      end
    end
  end
end
