# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/accounts/v1/homepage.proto for package 'Google.Shopping.Merchant.Accounts.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/accounts/v1/homepage_pb'

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          module HomepageService
            # Service to support an API for a store's homepage.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.accounts.v1.HomepageService'

              # Retrieves a store's homepage.
              rpc :GetHomepage, ::Google::Shopping::Merchant::Accounts::V1::GetHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1::Homepage
              # Updates a store's homepage. Executing this method requires admin access.
              rpc :UpdateHomepage, ::Google::Shopping::Merchant::Accounts::V1::UpdateHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1::Homepage
              # Claims a store's homepage. Executing this method requires admin access.
              #
              # If the homepage is already claimed, this will recheck the
              # verification (unless the business is exempted from claiming, which also
              # exempts from verification) and return a successful response. If ownership
              # can no longer be verified, it will return an error, but it won't clear the
              # claim.
              #
              # In case of failure, a canonical error message is returned:
              #
              #    * PERMISSION_DENIED: User doesn't have the necessary permissions on this
              #    Merchant Center account.
              #
              #    * FAILED_PRECONDITION:
              #
              #      - The account is not a Merchant Center account.
              #
              #      - Merchant Center account doesn't have a homepage.
              #
              #      - Claiming failed (in this case the error message contains more
              #      details).
              rpc :ClaimHomepage, ::Google::Shopping::Merchant::Accounts::V1::ClaimHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1::Homepage
              # Unclaims a store's homepage. Executing this method requires admin access.
              rpc :UnclaimHomepage, ::Google::Shopping::Merchant::Accounts::V1::UnclaimHomepageRequest, ::Google::Shopping::Merchant::Accounts::V1::Homepage
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
