# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/shopping/merchant/accounts/v1/version"

require "google/shopping/merchant/accounts/v1/gbp_accounts_service/credentials"
require "google/shopping/merchant/accounts/v1/gbp_accounts_service/paths"
require "google/shopping/merchant/accounts/v1/gbp_accounts_service/client"
require "google/shopping/merchant/accounts/v1/gbp_accounts_service/rest"

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          ##
          # The service facilitates the management of a merchant's Google Business
          # Profile (GBP) account settings. This API defines the following resource
          # model:
          # - {::Google::Shopping::Merchant::Accounts::V1::GbpAccount GbpAccount}
          #
          # @example Load this service and instantiate a gRPC client
          #
          #     require "google/shopping/merchant/accounts/v1/gbp_accounts_service"
          #     client = ::Google::Shopping::Merchant::Accounts::V1::GbpAccountsService::Client.new
          #
          # @example Load this service and instantiate a REST client
          #
          #     require "google/shopping/merchant/accounts/v1/gbp_accounts_service/rest"
          #     client = ::Google::Shopping::Merchant::Accounts::V1::GbpAccountsService::Rest::Client.new
          #
          module GbpAccountsService
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "gbp_accounts_service", "helpers.rb"
require "google/shopping/merchant/accounts/v1/gbp_accounts_service/helpers" if ::File.file? helper_path
