# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/shopping/merchant/accounts/v1/accounts.proto for package 'Google.Shopping.Merchant.Accounts.V1'
# Original file comments:
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/shopping/merchant/accounts/v1/accounts_pb'

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          module AccountsService
            # Service to support Accounts API.
            class Service

              include ::GRPC::GenericService

              self.marshal_class_method = :encode
              self.unmarshal_class_method = :decode
              self.service_name = 'google.shopping.merchant.accounts.v1.AccountsService'

              # Retrieves an account from your Merchant Center account.
              # After inserting, updating, or deleting an account, it may take several
              # minutes before changes take effect.
              rpc :GetAccount, ::Google::Shopping::Merchant::Accounts::V1::GetAccountRequest, ::Google::Shopping::Merchant::Accounts::V1::Account
              # Creates a Merchant Center account with additional configuration. Adds the
              # user that makes the request as an admin for the new account.
              rpc :CreateAndConfigureAccount, ::Google::Shopping::Merchant::Accounts::V1::CreateAndConfigureAccountRequest, ::Google::Shopping::Merchant::Accounts::V1::Account
              # Deletes the specified account regardless of its type: standalone, advanced
              # account or sub-account. Deleting an advanced account leads to the deletion
              # of all of its sub-accounts. This also deletes the account's [developer
              # registration
              # entity](/merchant/api/reference/rest/accounts_v1/accounts.developerRegistration)
              # and any associated GCP project to the account. Executing this method
              # requires admin access. The deletion succeeds only if the account does not
              # provide services to any other account and has no processed offers. You can
              # use the `force` parameter to override this.
              rpc :DeleteAccount, ::Google::Shopping::Merchant::Accounts::V1::DeleteAccountRequest, ::Google::Protobuf::Empty
              # Updates an account regardless of its type: standalone, advanced account or
              # sub-account. Executing this method requires admin access.
              rpc :UpdateAccount, ::Google::Shopping::Merchant::Accounts::V1::UpdateAccountRequest, ::Google::Shopping::Merchant::Accounts::V1::Account
              # Note: For the `accounts.list` method, quota and limits usage are charged
              # for each user, and not for the Merchant Center ID or the advanced account
              # ID. To list several sub-accounts, you should use the
              # `accounts.listSubaccounts` method, which is more suitable for advanced
              # accounts use case.
              rpc :ListAccounts, ::Google::Shopping::Merchant::Accounts::V1::ListAccountsRequest, ::Google::Shopping::Merchant::Accounts::V1::ListAccountsResponse
              # List all sub-accounts for a given advanced account. This is a
              # convenience wrapper for the more powerful `accounts.list` method. This
              # method will produce the same results as calling `ListsAccounts` with the
              # following filter:
              # `relationship(providerId={parent} AND service(type="ACCOUNT_AGGREGATION"))`
              rpc :ListSubAccounts, ::Google::Shopping::Merchant::Accounts::V1::ListSubAccountsRequest, ::Google::Shopping::Merchant::Accounts::V1::ListSubAccountsResponse
            end

            Stub = Service.rpc_stub_class
          end
        end
      end
    end
  end
end
