# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/shopping/merchant/accounts/v1/accountservices_pb"

module Google
  module Shopping
    module Merchant
      module Accounts
        module V1
          module AccountServicesService
            ##
            # Client for the AccountServicesService service.
            #
            # Service to support AccountService API.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "merchantapi.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :account_services_service_stub

              ##
              # Configure the AccountServicesService Client class.
              #
              # See {::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all AccountServicesService clients
              #   ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Shopping", "Merchant", "Accounts", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the AccountServicesService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @account_services_service_stub.universe_domain
              end

              ##
              # Create a new AccountServicesService client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the AccountServicesService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # These require statements are intentionally placed here to initialize
                # the gRPC module only when it's required.
                # See https://github.com/googleapis/toolkit/issues/446
                require "gapic/grpc"
                require "google/shopping/merchant/accounts/v1/accountservices_services_pb"

                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end
                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @account_services_service_stub = ::Gapic::ServiceStub.new(
                  ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Stub,
                  credentials: credentials,
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  channel_args: @config.channel_args,
                  interceptors: @config.interceptors,
                  channel_pool_config: @config.channel_pool,
                  logger: @config.logger
                )

                @account_services_service_stub.stub_logger&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @account_services_service_stub.logger
              end

              # Service calls

              ##
              # Retrieve an account service.
              #
              # @overload get_account_service(request, options = nil)
              #   Pass arguments to `get_account_service` via a request object, either of type
              #   {::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload get_account_service(name: nil)
              #   Pass arguments to `get_account_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the account service to get.
              #     Format: `accounts/{account}/services/{service}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/accounts/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest.new
              #
              #   # Call the get_account_service method.
              #   result = client.get_account_service request
              #
              #   # The returned object is of type Google::Shopping::Merchant::Accounts::V1::AccountService.
              #   p result
              #
              def get_account_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Accounts::V1::GetAccountServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.get_account_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::Accounts::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.get_account_service.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.get_account_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @account_services_service_stub.call_rpc :get_account_service, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # List account services for the specified accounts. Supports filtering.
              #
              # @overload list_account_services(request, options = nil)
              #   Pass arguments to `list_account_services` via a request object, either of type
              #   {::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload list_account_services(parent: nil, page_token: nil, page_size: nil)
              #   Pass arguments to `list_account_services` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent account of the account service to filter by.
              #     Format: `accounts/{account}`
              #   @param page_token [::String]
              #     Optional. The token returned by the previous `list` request.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of elements to return in the response. Use for
              #     paging. If no `page_size` is specified, `100` is used as the default value.
              #     The maximum allowed value is `1000`.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Gapic::PagedEnumerable<::Google::Shopping::Merchant::Accounts::V1::AccountService>]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Gapic::PagedEnumerable<::Google::Shopping::Merchant::Accounts::V1::AccountService>]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/accounts/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest.new
              #
              #   # Call the list_account_services method.
              #   result = client.list_account_services request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Shopping::Merchant::Accounts::V1::AccountService.
              #     p item
              #   end
              #
              def list_account_services request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Accounts::V1::ListAccountServicesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.list_account_services.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::Accounts::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.list_account_services.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.list_account_services.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @account_services_service_stub.call_rpc :list_account_services, request, options: options do |response, operation|
                  response = ::Gapic::PagedEnumerable.new @account_services_service_stub, :list_account_services, request, response, operation, options
                  yield response, operation if block_given?
                  throw :response, response
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Propose an account service.
              #
              # @overload propose_account_service(request, options = nil)
              #   Pass arguments to `propose_account_service` via a request object, either of type
              #   {::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload propose_account_service(parent: nil, provider: nil, account_service: nil)
              #   Pass arguments to `propose_account_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent account for the service.
              #     Format: `accounts/{account}`
              #   @param provider [::String]
              #     Required. The provider of the service. Either the reference to an account
              #     such as `providers/123` or a well-known service provider (one of
              #     `providers/GOOGLE_ADS` or `providers/GOOGLE_BUSINESS_PROFILE`).
              #   @param account_service [::Google::Shopping::Merchant::Accounts::V1::AccountService, ::Hash]
              #     Required. The account service to propose.
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/accounts/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest.new
              #
              #   # Call the propose_account_service method.
              #   result = client.propose_account_service request
              #
              #   # The returned object is of type Google::Shopping::Merchant::Accounts::V1::AccountService.
              #   p result
              #
              def propose_account_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Accounts::V1::ProposeAccountServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.propose_account_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::Accounts::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.parent
                  header_params["parent"] = request.parent
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.propose_account_service.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.propose_account_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @account_services_service_stub.call_rpc :propose_account_service, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Approve an account service proposal.
              #
              # @overload approve_account_service(request, options = nil)
              #   Pass arguments to `approve_account_service` via a request object, either of type
              #   {::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload approve_account_service(name: nil)
              #   Pass arguments to `approve_account_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the account service to approve.
              #     Format: `accounts/{account}/services/{service}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Shopping::Merchant::Accounts::V1::AccountService]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/accounts/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest.new
              #
              #   # Call the approve_account_service method.
              #   result = client.approve_account_service request
              #
              #   # The returned object is of type Google::Shopping::Merchant::Accounts::V1::AccountService.
              #   p result
              #
              def approve_account_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Accounts::V1::ApproveAccountServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.approve_account_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::Accounts::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.approve_account_service.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.approve_account_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @account_services_service_stub.call_rpc :approve_account_service, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Reject an account service (both proposed and approve services can be
              # rejected).
              #
              # @overload reject_account_service(request, options = nil)
              #   Pass arguments to `reject_account_service` via a request object, either of type
              #   {::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
              #
              # @overload reject_account_service(name: nil)
              #   Pass arguments to `reject_account_service` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the account service to reject.
              #     Format: `accounts/{account}/services/{service}`
              #
              # @yield [response, operation] Access the result along with the RPC operation
              # @yieldparam response [::Google::Protobuf::Empty]
              # @yieldparam operation [::GRPC::ActiveCall::Operation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the RPC is aborted.
              #
              # @example Basic example
              #   require "google/shopping/merchant/accounts/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest.new
              #
              #   # Call the reject_account_service method.
              #   result = client.reject_account_service request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def reject_account_service request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Shopping::Merchant::Accounts::V1::RejectAccountServiceRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                metadata = @config.rpcs.reject_account_service.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Shopping::Merchant::Accounts::V1::VERSION
                metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                header_params = {}
                if request.name
                  header_params["name"] = request.name
                end

                request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
                metadata[:"x-goog-request-params"] ||= request_params_header

                options.apply_defaults timeout:      @config.rpcs.reject_account_service.timeout,
                                       metadata:     metadata,
                                       retry_policy: @config.rpcs.reject_account_service.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @account_services_service_stub.call_rpc :reject_account_service, request, options: options do |response, operation|
                  yield response, operation if block_given?
                end
              rescue ::GRPC::BadStatus => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the AccountServicesService API.
              #
              # This class represents the configuration for AccountServicesService,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # get_account_service to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_account_service.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.get_account_service.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
              #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
              #    *  (`nil`) indicating no credentials
              #
              #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
              #     is deprecated. Providing an unvalidated credential configuration to
              #     Google APIs can compromise the security of your systems and data.
              #
              #   @example
              #
              #     # The recommended way to provide credentials is to use the `make_creds` method
              #     # on the appropriate credentials class for your environment.
              #
              #     require "googleauth"
              #
              #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
              #       json_key_io: ::File.open("/path/to/keyfile.json")
              #     )
              #
              #     client = ::Google::Shopping::Merchant::Accounts::V1::AccountServicesService::Client.new do |config|
              #       config.credentials = credentials
              #     end
              #
              #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] channel_args
              #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
              #   `GRPC::Core::Channel` object is provided as the credential.
              #   @return [::Hash]
              # @!attribute [rw] interceptors
              #   An array of interceptors that are run before calls are executed.
              #   @return [::Array<::GRPC::ClientInterceptor>]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional gRPC headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "merchantapi.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
                config_attr :interceptors,  nil, ::Array, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration for the channel pool
                # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
                #
                def channel_pool
                  @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
                end

                ##
                # Configuration RPC class for the AccountServicesService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `get_account_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_account_service
                  ##
                  # RPC-specific configuration for `list_account_services`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_account_services
                  ##
                  # RPC-specific configuration for `propose_account_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :propose_account_service
                  ##
                  # RPC-specific configuration for `approve_account_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_account_service
                  ##
                  # RPC-specific configuration for `reject_account_service`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reject_account_service

                  # @private
                  def initialize parent_rpcs = nil
                    get_account_service_config = parent_rpcs.get_account_service if parent_rpcs.respond_to? :get_account_service
                    @get_account_service = ::Gapic::Config::Method.new get_account_service_config
                    list_account_services_config = parent_rpcs.list_account_services if parent_rpcs.respond_to? :list_account_services
                    @list_account_services = ::Gapic::Config::Method.new list_account_services_config
                    propose_account_service_config = parent_rpcs.propose_account_service if parent_rpcs.respond_to? :propose_account_service
                    @propose_account_service = ::Gapic::Config::Method.new propose_account_service_config
                    approve_account_service_config = parent_rpcs.approve_account_service if parent_rpcs.respond_to? :approve_account_service
                    @approve_account_service = ::Gapic::Config::Method.new approve_account_service_config
                    reject_account_service_config = parent_rpcs.reject_account_service if parent_rpcs.respond_to? :reject_account_service
                    @reject_account_service = ::Gapic::Config::Method.new reject_account_service_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
