# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/shopping/css/version"

require "googleauth"

module Google
  module Shopping
    module Css
      ##
      # Create a new client object for AccountsService.
      #
      # By default, this returns an instance of
      # [Google::Shopping::Css::V1::AccountsService::Client](https://rubydoc.info/gems/google-shopping-css-v1/Google/Shopping/Css/V1/AccountsService/Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AccountsService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the AccountsService service.
      # You can determine whether the method will succeed by calling
      # {Google::Shopping::Css.accounts_service_available?}.
      #
      # ## About AccountsService
      #
      # Service for managing CSS/MC account information.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.accounts_service version: :v1, transport: :grpc, &block
        require "google/shopping/css/#{version.to_s.downcase}"

        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Shopping::Css.const_get(package_name).const_get(:AccountsService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AccountsService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Shopping::Css.accounts_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AccountsService service,
      # or if the versioned client gem needs an update to support the AccountsService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.accounts_service_available? version: :v1, transport: :grpc
        require "google/shopping/css/#{version.to_s.downcase}"
        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Shopping::Css.const_get package_name
        return false unless service_module.const_defined? :AccountsService
        service_module = service_module.const_get :AccountsService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AccountLabelsService.
      #
      # By default, this returns an instance of
      # [Google::Shopping::Css::V1::AccountLabelsService::Client](https://rubydoc.info/gems/google-shopping-css-v1/Google/Shopping/Css/V1/AccountLabelsService/Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AccountLabelsService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the AccountLabelsService service.
      # You can determine whether the method will succeed by calling
      # {Google::Shopping::Css.account_labels_service_available?}.
      #
      # ## About AccountLabelsService
      #
      # Manages Merchant Center and CSS accounts labels.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.account_labels_service version: :v1, transport: :grpc, &block
        require "google/shopping/css/#{version.to_s.downcase}"

        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Shopping::Css.const_get(package_name).const_get(:AccountLabelsService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AccountLabelsService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Shopping::Css.account_labels_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AccountLabelsService service,
      # or if the versioned client gem needs an update to support the AccountLabelsService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.account_labels_service_available? version: :v1, transport: :grpc
        require "google/shopping/css/#{version.to_s.downcase}"
        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Shopping::Css.const_get package_name
        return false unless service_module.const_defined? :AccountLabelsService
        service_module = service_module.const_get :AccountLabelsService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CssProductInputsService.
      #
      # By default, this returns an instance of
      # [Google::Shopping::Css::V1::CssProductInputsService::Client](https://rubydoc.info/gems/google-shopping-css-v1/Google/Shopping/Css/V1/CssProductInputsService/Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CssProductInputsService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CssProductInputsService service.
      # You can determine whether the method will succeed by calling
      # {Google::Shopping::Css.css_product_inputs_service_available?}.
      #
      # ## About CssProductInputsService
      #
      # Service to use CssProductInput resource.
      # This service helps to insert/update/delete CSS Products.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.css_product_inputs_service version: :v1, transport: :grpc, &block
        require "google/shopping/css/#{version.to_s.downcase}"

        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Shopping::Css.const_get(package_name).const_get(:CssProductInputsService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CssProductInputsService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Shopping::Css.css_product_inputs_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CssProductInputsService service,
      # or if the versioned client gem needs an update to support the CssProductInputsService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.css_product_inputs_service_available? version: :v1, transport: :grpc
        require "google/shopping/css/#{version.to_s.downcase}"
        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Shopping::Css.const_get package_name
        return false unless service_module.const_defined? :CssProductInputsService
        service_module = service_module.const_get :CssProductInputsService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CssProductsService.
      #
      # By default, this returns an instance of
      # [Google::Shopping::Css::V1::CssProductsService::Client](https://rubydoc.info/gems/google-shopping-css-v1/Google/Shopping/Css/V1/CssProductsService/Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CssProductsService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CssProductsService service.
      # You can determine whether the method will succeed by calling
      # {Google::Shopping::Css.css_products_service_available?}.
      #
      # ## About CssProductsService
      #
      # Service for doing get and list on Css Products(a.k.a Aggregate Offers
      # internally).
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.css_products_service version: :v1, transport: :grpc, &block
        require "google/shopping/css/#{version.to_s.downcase}"

        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Shopping::Css.const_get(package_name).const_get(:CssProductsService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CssProductsService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Shopping::Css.css_products_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CssProductsService service,
      # or if the versioned client gem needs an update to support the CssProductsService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.css_products_service_available? version: :v1, transport: :grpc
        require "google/shopping/css/#{version.to_s.downcase}"
        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Shopping::Css.const_get package_name
        return false unless service_module.const_defined? :CssProductsService
        service_module = service_module.const_get :CssProductsService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for QuotaService.
      #
      # By default, this returns an instance of
      # [Google::Shopping::Css::V1::QuotaService::Client](https://rubydoc.info/gems/google-shopping-css-v1/Google/Shopping/Css/V1/QuotaService/Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the QuotaService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the QuotaService service.
      # You can determine whether the method will succeed by calling
      # {Google::Shopping::Css.quota_service_available?}.
      #
      # ## About QuotaService
      #
      # Service to get method call quota information per CSS API method.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.quota_service version: :v1, transport: :grpc, &block
        require "google/shopping/css/#{version.to_s.downcase}"

        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Shopping::Css.const_get(package_name).const_get(:QuotaService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the QuotaService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Shopping::Css.quota_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the QuotaService service,
      # or if the versioned client gem needs an update to support the QuotaService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.quota_service_available? version: :v1, transport: :grpc
        require "google/shopping/css/#{version.to_s.downcase}"
        package_name = Google::Shopping::Css
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Shopping::Css.const_get package_name
        return false unless service_module.const_defined? :QuotaService
        service_module = service_module.const_get :QuotaService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end
    end
  end
end

helper_path = ::File.join __dir__, "css", "helpers.rb"
require "google/shopping/css/helpers" if ::File.file? helper_path
