# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/css/v1/css_product_inputs_pb"
require "google/shopping/css/v1/css_product_inputs_service"

class ::Google::Shopping::Css::V1::CssProductInputsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_insert_css_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Css::V1::CssProductInput.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    css_product_input = {}
    feed_id = 42

    insert_css_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :insert_css_product_input, name
      assert_kind_of ::Google::Shopping::Css::V1::InsertCssProductInputRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Css::V1::CssProductInput), request["css_product_input"]
      assert_equal 42, request["feed_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, insert_css_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::CssProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.insert_css_product_input({ parent: parent, css_product_input: css_product_input, feed_id: feed_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.insert_css_product_input parent: parent, css_product_input: css_product_input, feed_id: feed_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.insert_css_product_input ::Google::Shopping::Css::V1::InsertCssProductInputRequest.new(parent: parent, css_product_input: css_product_input, feed_id: feed_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.insert_css_product_input({ parent: parent, css_product_input: css_product_input, feed_id: feed_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.insert_css_product_input(::Google::Shopping::Css::V1::InsertCssProductInputRequest.new(parent: parent, css_product_input: css_product_input, feed_id: feed_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, insert_css_product_input_client_stub.call_rpc_count
    end
  end

  def test_update_css_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Css::V1::CssProductInput.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    css_product_input = {}
    update_mask = {}

    update_css_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_css_product_input, name
      assert_kind_of ::Google::Shopping::Css::V1::UpdateCssProductInputRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Shopping::Css::V1::CssProductInput), request["css_product_input"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_css_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::CssProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_css_product_input({ css_product_input: css_product_input, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_css_product_input css_product_input: css_product_input, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_css_product_input ::Google::Shopping::Css::V1::UpdateCssProductInputRequest.new(css_product_input: css_product_input, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_css_product_input({ css_product_input: css_product_input, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_css_product_input(::Google::Shopping::Css::V1::UpdateCssProductInputRequest.new(css_product_input: css_product_input, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_css_product_input_client_stub.call_rpc_count
    end
  end

  def test_delete_css_product_input
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    supplemental_feed_id = 42

    delete_css_product_input_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_css_product_input, name
      assert_kind_of ::Google::Shopping::Css::V1::DeleteCssProductInputRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["supplemental_feed_id"]
      assert request.has_supplemental_feed_id?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_css_product_input_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::CssProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_css_product_input({ name: name, supplemental_feed_id: supplemental_feed_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_css_product_input name: name, supplemental_feed_id: supplemental_feed_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_css_product_input ::Google::Shopping::Css::V1::DeleteCssProductInputRequest.new(name: name, supplemental_feed_id: supplemental_feed_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_css_product_input({ name: name, supplemental_feed_id: supplemental_feed_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_css_product_input(::Google::Shopping::Css::V1::DeleteCssProductInputRequest.new(name: name, supplemental_feed_id: supplemental_feed_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_css_product_input_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Css::V1::CssProductInputsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Css::V1::CssProductInputsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Css::V1::CssProductInputsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Css::V1::CssProductInputsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
