# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/shopping/css/v1/accounts_pb"
require "google/shopping/css/v1/accounts_service"

class ::Google::Shopping::Css::V1::AccountsService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_child_accounts
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Css::V1::ListChildAccountsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    label_id = 42
    full_name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_child_accounts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_child_accounts, name
      assert_kind_of ::Google::Shopping::Css::V1::ListChildAccountsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["label_id"]
      assert request.has_label_id?
      assert_equal "hello world", request["full_name"]
      assert request.has_full_name?
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_child_accounts_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::AccountsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_child_accounts({ parent: parent, label_id: label_id, full_name: full_name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_child_accounts parent: parent, label_id: label_id, full_name: full_name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_child_accounts ::Google::Shopping::Css::V1::ListChildAccountsRequest.new(parent: parent, label_id: label_id, full_name: full_name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_child_accounts({ parent: parent, label_id: label_id, full_name: full_name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_child_accounts(::Google::Shopping::Css::V1::ListChildAccountsRequest.new(parent: parent, label_id: label_id, full_name: full_name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_child_accounts_client_stub.call_rpc_count
    end
  end

  def test_get_account
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Css::V1::Account.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    parent = "hello world"

    get_account_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_account, name
      assert_kind_of ::Google::Shopping::Css::V1::GetAccountRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["parent"]
      assert request.has_parent?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_account_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::AccountsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_account({ name: name, parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_account name: name, parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_account ::Google::Shopping::Css::V1::GetAccountRequest.new(name: name, parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_account({ name: name, parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_account(::Google::Shopping::Css::V1::GetAccountRequest.new(name: name, parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_account_client_stub.call_rpc_count
    end
  end

  def test_update_labels
    # Create GRPC objects.
    grpc_response = ::Google::Shopping::Css::V1::Account.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    label_ids = [42]
    parent = "hello world"

    update_labels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_labels, name
      assert_kind_of ::Google::Shopping::Css::V1::UpdateAccountLabelsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal [42], request["label_ids"]
      assert_equal "hello world", request["parent"]
      assert request.has_parent?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_labels_client_stub do
      # Create client
      client = ::Google::Shopping::Css::V1::AccountsService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_labels({ name: name, label_ids: label_ids, parent: parent }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_labels name: name, label_ids: label_ids, parent: parent do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_labels ::Google::Shopping::Css::V1::UpdateAccountLabelsRequest.new(name: name, label_ids: label_ids, parent: parent) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_labels({ name: name, label_ids: label_ids, parent: parent }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_labels(::Google::Shopping::Css::V1::UpdateAccountLabelsRequest.new(name: name, label_ids: label_ids, parent: parent), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_labels_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Css::V1::AccountsService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Shopping::Css::V1::AccountsService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Shopping::Css::V1::AccountsService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Shopping::Css::V1::AccountsService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
