# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Css
      module V1
        # The request message for the `GetCssProduct` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the CSS product to retrieve.
        class GetCssProductRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The processed CSS Product.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the CSS Product.
        #     Format:
        #     `"accounts/{account}/cssProducts/{css_product}"`
        # @!attribute [r] raw_provided_id
        #   @return [::String]
        #     Output only. Your unique raw identifier for the product.
        # @!attribute [r] content_language
        #   @return [::String]
        #     Output only. The two-letter [ISO
        #     639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
        #     product.
        # @!attribute [r] feed_label
        #   @return [::String]
        #     Output only. The feed label for the product.
        # @!attribute [r] attributes
        #   @return [::Google::Shopping::Css::V1::Attributes]
        #     Output only. A list of product attributes.
        # @!attribute [r] custom_attributes
        #   @return [::Array<::Google::Shopping::Type::CustomAttribute>]
        #     Output only. A list of custom (CSS-provided) attributes. It can also be
        #     used to submit any attribute of the feed specification in its generic form
        #     (for example,
        #     `{ "name": "size type", "value": "regular" }`).
        #     This is useful for submitting attributes not explicitly exposed by the
        #     API, such as additional attributes used for Buy on Google.
        # @!attribute [r] css_product_status
        #   @return [::Google::Shopping::Css::V1::CssProductStatus]
        #     Output only. The status of a product, data validation issues, that is,
        #     information about a product computed asynchronously.
        class CssProduct
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the ListCssProducts method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The account/domain to list processed CSS Products for.
        #     Format: accounts/\\{account}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of CSS Products to return. The service may return
        #     fewer than this value.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000. If
        #     unspecified, the maximum number of CSS products will be returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListCssProducts` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListCssProducts`
        #     must match the call that provided the page token.
        class ListCssProductsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the ListCssProducts method.
        # @!attribute [rw] css_products
        #   @return [::Array<::Google::Shopping::Css::V1::CssProduct>]
        #     The processed CSS products from the specified account. These are your
        #     processed CSS products after applying rules and supplemental feeds.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListCssProductsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
