# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Css
      module V1
        # Attributes for CSS Product.
        # @!attribute [rw] cpp_link
        #   @return [::String]
        #     URL directly linking to your the Product Detail Page of the CSS.
        # @!attribute [rw] cpp_mobile_link
        #   @return [::String]
        #     URL for the mobile-optimized version of the Product Detail Page of the CSS.
        # @!attribute [rw] cpp_ads_redirect
        #   @return [::String]
        #     Allows advertisers to override the item URL when the product is shown
        #     within the context of Product Ads.
        # @!attribute [rw] low_price
        #   @return [::Google::Shopping::Type::Price]
        #     Low Price of the CSS Product.
        # @!attribute [rw] high_price
        #   @return [::Google::Shopping::Type::Price]
        #     High Price of the CSS Product.
        # @!attribute [rw] number_of_offers
        #   @return [::Integer]
        #     The number of CSS Products.
        # @!attribute [rw] headline_offer_condition
        #   @return [::String]
        #     Condition of the headline offer.
        # @!attribute [rw] headline_offer_price
        #   @return [::Google::Shopping::Type::Price]
        #     Headline Price of the CSS Product.
        # @!attribute [rw] headline_offer_link
        #   @return [::String]
        #     Link to the headline offer.
        # @!attribute [rw] headline_offer_mobile_link
        #   @return [::String]
        #     Mobile Link to the headline offer.
        # @!attribute [rw] headline_offer_shipping_price
        #   @return [::Google::Shopping::Type::Price]
        #     Headline Price of the CSS Product.
        # @!attribute [rw] title
        #   @return [::String]
        #     Title of the item.
        # @!attribute [rw] image_link
        #   @return [::String]
        #     URL of an image of the item.
        # @!attribute [rw] additional_image_links
        #   @return [::Array<::String>]
        #     Additional URL of images of the item.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the item.
        # @!attribute [rw] brand
        #   @return [::String]
        #     Product Related Attributes.[14-36]
        #     Brand of the item.
        # @!attribute [rw] mpn
        #   @return [::String]
        #     Manufacturer Part Number
        #     ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
        #     item.
        # @!attribute [rw] gtin
        #   @return [::String]
        #     Global Trade Item Number
        #     ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
        #     item.
        # @!attribute [rw] product_types
        #   @return [::Array<::String>]
        #     Categories of the item (formatted as in [products data
        #     specification](https://support.google.com/merchants/answer/6324406)).
        # @!attribute [rw] google_product_category
        #   @return [::String]
        #     Google's category of the item (see [Google product
        #     taxonomy](https://support.google.com/merchants/answer/1705911)). When
        #     querying products, this field will contain the user provided value. There
        #     is currently no way to get back the auto assigned google product
        #     categories through the API.
        # @!attribute [rw] adult
        #   @return [::Boolean]
        #     Set to true if the item is targeted towards adults.
        # @!attribute [rw] multipack
        #   @return [::Integer]
        #     The number of identical products in a merchant-defined multipack.
        # @!attribute [rw] is_bundle
        #   @return [::Boolean]
        #     Whether the item is a merchant-defined bundle. A bundle is a custom
        #     grouping of different products sold by a merchant for a single price.
        # @!attribute [rw] age_group
        #   @return [::String]
        #     Target age group of the item.
        # @!attribute [rw] color
        #   @return [::String]
        #     Color of the item.
        # @!attribute [rw] gender
        #   @return [::String]
        #     Target gender of the item.
        # @!attribute [rw] material
        #   @return [::String]
        #     The material of which the item is made.
        # @!attribute [rw] pattern
        #   @return [::String]
        #     The item's pattern (e.g. polka dots).
        # @!attribute [rw] size
        #   @return [::String]
        #     Size of the item. Only one value is allowed. For variants with different
        #     sizes, insert a separate product for each size with the same
        #     `itemGroupId` value (see
        #     [https://support.google.com/merchants/answer/6324492](size definition)).
        # @!attribute [rw] size_system
        #   @return [::String]
        #     System in which the size is specified. Recommended for apparel items.
        # @!attribute [rw] size_types
        #   @return [::Array<::String>]
        #     The cut of the item. It can be used to represent combined size types for
        #     apparel items. Maximum two of size types can be provided (see
        #     [https://support.google.com/merchants/answer/6324497](size type)).
        # @!attribute [rw] item_group_id
        #   @return [::String]
        #     Shared identifier for all variants of the same product.
        # @!attribute [rw] product_details
        #   @return [::Array<::Google::Shopping::Css::V1::ProductDetail>]
        #     Technical specification or additional product details.
        # @!attribute [rw] product_weight
        #   @return [::Google::Shopping::Css::V1::ProductWeight]
        #     The weight of the product in the units provided. The value must be
        #     between 0 (exclusive) and 2000 (inclusive).
        # @!attribute [rw] product_length
        #   @return [::Google::Shopping::Css::V1::ProductDimension]
        #     The length of the product in the units provided. The value must be
        #     between 0 (exclusive) and 3000 (inclusive).
        # @!attribute [rw] product_width
        #   @return [::Google::Shopping::Css::V1::ProductDimension]
        #     The width of the product in the units provided. The value must be between
        #     0 (exclusive) and 3000 (inclusive).
        # @!attribute [rw] product_height
        #   @return [::Google::Shopping::Css::V1::ProductDimension]
        #     The height of the product in the units provided. The value must be
        #     between
        #     0 (exclusive) and 3000 (inclusive).
        # @!attribute [rw] product_highlights
        #   @return [::Array<::String>]
        #     Bullet points describing the most relevant highlights of a product.
        # @!attribute [rw] certifications
        #   @return [::Array<::Google::Shopping::Css::V1::Certification>]
        #     A list of certificates claimed by the CSS for the given product.
        # @!attribute [rw] expiration_date
        #   @return [::Google::Protobuf::Timestamp]
        #     Date on which the item should expire, as specified upon insertion, in
        #     [ISO
        #     8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
        #     expiration date is exposed in `productstatuses` as
        #     [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
        #     and might be earlier if `expirationDate` is too far in the future.
        #     Note: It may take 2+ days from the expiration date for the item to
        #     actually get deleted.
        # @!attribute [rw] included_destinations
        #   @return [::Array<::String>]
        #     The list of destinations to include for this target (corresponds to
        #     checked check boxes in Merchant Center). Default destinations are always
        #     included unless provided in `excludedDestinations`.
        # @!attribute [rw] excluded_destinations
        #   @return [::Array<::String>]
        #     The list of destinations to exclude for this target (corresponds to
        #     unchecked check boxes in Merchant Center).
        # @!attribute [rw] pause
        #   @return [::String]
        #     Publication of this item will be temporarily paused.
        # @!attribute [rw] custom_label_0
        #   @return [::String]
        #     Custom label 0 for custom grouping of items in a Shopping campaign.
        # @!attribute [rw] custom_label_1
        #   @return [::String]
        #     Custom label 1 for custom grouping of items in a Shopping campaign.
        # @!attribute [rw] custom_label_2
        #   @return [::String]
        #     Custom label 2 for custom grouping of items in a Shopping campaign.
        # @!attribute [rw] custom_label_3
        #   @return [::String]
        #     Custom label 3 for custom grouping of items in a Shopping campaign.
        # @!attribute [rw] custom_label_4
        #   @return [::String]
        #     Custom label 4 for custom grouping of items in a Shopping campaign.
        # @!attribute [rw] headline_offer_installment
        #   @return [::Google::Shopping::Css::V1::HeadlineOfferInstallment]
        #     Number and amount of installments to pay for an item.
        # @!attribute [rw] headline_offer_subscription_cost
        #   @return [::Google::Shopping::Css::V1::HeadlineOfferSubscriptionCost]
        #     Number of periods (months or years) and amount of payment per period
        #     for an item with an associated subscription contract.
        class Attributes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The certification for the product. Use the this attribute to describe
        # certifications, such as energy efficiency ratings, associated with a product.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the certification. At this time, the most common value is
        #     "EPREL", which represents energy efficiency certifications in the EU
        #     European Registry for Energy Labeling (EPREL) database.
        # @!attribute [rw] authority
        #   @return [::String]
        #     The authority or certification body responsible for issuing the
        #     certification. At this time, the most common value is "EC" or
        #     “European_Commission” for energy labels in the EU.
        # @!attribute [rw] code
        #   @return [::String]
        #     The code of the certification. For example, for the EPREL certificate with
        #     the link https://eprel.ec.europa.eu/screen/product/dishwashers2019/123456
        #     the code is 123456. The code is required for European Energy Labels.
        class Certification
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The product details.
        # @!attribute [rw] section_name
        #   @return [::String]
        #     The section header used to group a set of product details.
        # @!attribute [rw] attribute_name
        #   @return [::String]
        #     The name of the product detail.
        # @!attribute [rw] attribute_value
        #   @return [::String]
        #     The value of the product detail.
        class ProductDetail
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The dimension of the product.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Required. The dimension value represented as a number. The value can have a
        #     maximum precision of four decimal places.
        # @!attribute [rw] unit
        #   @return [::String]
        #     Required. The dimension units.
        #     Acceptable values are:
        #       * "`in`"
        #       * "`cm`"
        class ProductDimension
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The weight of the product.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Required. The weight represented as a number. The weight can have a maximum
        #     precision of four decimal places.
        # @!attribute [rw] unit
        #   @return [::String]
        #     Required. The weight unit.
        #     Acceptable values are:
        #       * "`g`"
        #       * "`kg`"
        #       * "`oz`"
        #       * "`lb`"
        class ProductWeight
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The status of the Css Product, data validation issues, that is,
        # information about the Css Product computed asynchronously.
        # @!attribute [rw] destination_statuses
        #   @return [::Array<::Google::Shopping::Css::V1::CssProductStatus::DestinationStatus>]
        #     The intended destinations for the product.
        # @!attribute [rw] item_level_issues
        #   @return [::Array<::Google::Shopping::Css::V1::CssProductStatus::ItemLevelIssue>]
        #     A list of all issues associated with the product.
        # @!attribute [rw] creation_date
        #   @return [::Google::Protobuf::Timestamp]
        #     Date on which the item has been created, in [ISO
        #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
        # @!attribute [rw] last_update_date
        #   @return [::Google::Protobuf::Timestamp]
        #     Date on which the item has been last updated, in [ISO
        #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
        # @!attribute [rw] google_expiration_date
        #   @return [::Google::Protobuf::Timestamp]
        #     Date on which the item expires, in [ISO
        #     8601](http://en.wikipedia.org/wiki/ISO_8601) format.
        class CssProductStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The destination status of the product status.
          # @!attribute [rw] destination
          #   @return [::String]
          #     The name of the destination
          # @!attribute [rw] approved_countries
          #   @return [::Array<::String>]
          #     List of country codes (ISO 3166-1 alpha-2) where the CSS Product is
          #     approved.
          # @!attribute [rw] pending_countries
          #   @return [::Array<::String>]
          #     List of country codes (ISO 3166-1 alpha-2) where the CSS Product is
          #     pending approval.
          # @!attribute [rw] disapproved_countries
          #   @return [::Array<::String>]
          #     List of country codes (ISO 3166-1 alpha-2) where the CSS Product is
          #     disapproved.
          class DestinationStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The ItemLevelIssue of the product status.
          # @!attribute [rw] code
          #   @return [::String]
          #     The error code of the issue.
          # @!attribute [rw] servability
          #   @return [::String]
          #     How this issue affects serving of the CSS Product.
          # @!attribute [rw] resolution
          #   @return [::String]
          #     Whether the issue can be resolved by the merchant.
          # @!attribute [rw] attribute
          #   @return [::String]
          #     The attribute's name, if the issue is caused by a single attribute.
          # @!attribute [rw] destination
          #   @return [::String]
          #     The destination the issue applies to.
          # @!attribute [rw] description
          #   @return [::String]
          #     A short issue description in English.
          # @!attribute [rw] detail
          #   @return [::String]
          #     A detailed issue description in English.
          # @!attribute [rw] documentation
          #   @return [::String]
          #     The URL of a web page to help with resolving this issue.
          # @!attribute [rw] applicable_countries
          #   @return [::Array<::String>]
          #     List of country codes (ISO 3166-1 alpha-2) where issue applies to the
          #     CSS Product.
          class ItemLevelIssue
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The SubscriptionCost of the product.
        # @!attribute [rw] period
        #   @return [::Google::Shopping::Css::V1::SubscriptionPeriod]
        #     The type of subscription period.
        #     Supported values are:
        #       * "`month`"
        #       * "`year`"
        # @!attribute [rw] period_length
        #   @return [::Integer]
        #     The number of subscription periods the buyer has to pay.
        # @!attribute [rw] amount
        #   @return [::Google::Shopping::Type::Price]
        #     The amount the buyer has to pay per subscription period.
        class HeadlineOfferSubscriptionCost
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A message that represents installment.
        # @!attribute [rw] months
        #   @return [::Integer]
        #     The number of installments the buyer has to pay.
        # @!attribute [rw] amount
        #   @return [::Google::Shopping::Type::Price]
        #     The amount the buyer has to pay per month.
        # @!attribute [rw] downpayment
        #   @return [::Google::Shopping::Type::Price]
        #     The up-front down payment amount the buyer has to pay.
        class HeadlineOfferInstallment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The subscription period of the product.
        module SubscriptionPeriod
          # Indicates that the subscription period is unspecified.
          SUBSCRIPTION_PERIOD_UNSPECIFIED = 0

          # Indicates that the subscription period is month.
          MONTH = 1

          # Indicates that the subscription period is year.
          YEAR = 2
        end
      end
    end
  end
end
