# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Css
      module V1
        # Label assigned by CSS domain or CSS group to one of its sub-accounts.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the label.
        #     Format: accounts/\\{account}/labels/\\{label}
        # @!attribute [r] label_id
        #   @return [::Integer]
        #     Output only. The ID of the label.
        # @!attribute [r] account_id
        #   @return [::Integer]
        #     Output only. The ID of account this label belongs to.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of this label.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of this label.
        # @!attribute [r] label_type
        #   @return [::Google::Shopping::Css::V1::AccountLabel::LabelType]
        #     Output only. The type of this label.
        class AccountLabel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The label type.
          module LabelType
            # Unknown label type.
            LABEL_TYPE_UNSPECIFIED = 0

            # Indicates that the label was created manually.
            MANUAL = 1

            # Indicates that the label was created automatically by CSS Center.
            AUTOMATIC = 2
          end
        end

        # Request message for the `ListAccountLabels` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent account.
        #     Format: accounts/\\{account}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of labels to return. The service may return fewer than
        #     this value.
        #     If unspecified, at most 50 labels will be returned.
        #     The maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAccountLabels` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListAccountLabels` must
        #     match the call that provided the page token.
        class ListAccountLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `ListAccountLabels` method.
        # @!attribute [rw] account_labels
        #   @return [::Array<::Google::Shopping::Css::V1::AccountLabel>]
        #     The labels from the specified account.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListAccountLabelsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the 'CreateAccountLanel' method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent account.
        #     Format: accounts/\\{account}
        # @!attribute [rw] account_label
        #   @return [::Google::Shopping::Css::V1::AccountLabel]
        #     Required. The label to create.
        class CreateAccountLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the `UpdateAccountLabel` method.
        # @!attribute [rw] account_label
        #   @return [::Google::Shopping::Css::V1::AccountLabel]
        #     Required. The updated label. All fields must be provided.
        class UpdateAccountLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the 'DeleteAccountLabel' method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the label to delete.
        #     Format:  accounts/\\{account}/labels/\\{label}
        class DeleteAccountLabelRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
