# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Shopping
    module Css
      module V1
        # The request message for the `ListChildAccounts` method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent account. Must be a CSS group or domain.
        #     Format: accounts/\\{account}
        # @!attribute [rw] label_id
        #   @return [::Integer]
        #     If set, only the MC accounts with the given label ID will be returned.
        # @!attribute [rw] full_name
        #   @return [::String]
        #     If set, only the MC accounts with the given name (case sensitive) will be
        #     returned.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of accounts to return. The service may return
        #     fewer than this value. If unspecified, at most 50 accounts will be
        #     returned. The maximum value is 100; values above 100 will be coerced to
        #     100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListChildAccounts` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListChildAccounts` must
        #     match the call that provided the page token.
        class ListChildAccountsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the `ListChildAccounts` method.
        # @!attribute [rw] accounts
        #   @return [::Array<::Google::Shopping::Css::V1::Account>]
        #     The CSS/MC accounts returned for the specified CSS parent account.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListChildAccountsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the `GetAccount` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the managed CSS/MC account.
        #     Format: accounts/\\{account}
        # @!attribute [rw] parent
        #   @return [::String]
        #     Optional. Only required when retrieving MC account information.
        #     The CSS domain that is the parent resource of the MC account.
        #     Format: accounts/\\{account}
        class GetAccountRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the `UpdateLabels` method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The label resource name.
        #     Format: accounts/\\{account}
        # @!attribute [rw] label_ids
        #   @return [::Array<::Integer>]
        #     The list of label IDs to overwrite the existing account label IDs.
        #     If the list is empty, all currently assigned label IDs will be deleted.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Optional. Only required when updating MC account labels.
        #     The CSS domain that is the parent resource of the MC account.
        #     Format: accounts/\\{account}
        class UpdateAccountLabelsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about CSS/MC account.
        # @!attribute [rw] name
        #   @return [::String]
        #     The label resource name.
        #     Format: accounts/\\{account}
        # @!attribute [r] full_name
        #   @return [::String]
        #     Output only. Immutable. The CSS/MC account's full name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The CSS/MC account's short display name.
        # @!attribute [r] homepage_uri
        #   @return [::String]
        #     Output only. Immutable. The CSS/MC account's homepage.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The CSS/MC account's parent resource. CSS group for CSS domains; CSS
        #     domain for MC accounts. Returned only if the user has access to the
        #     parent account.
        #     Note: For MC sub-accounts, this is also the CSS domain that is the parent
        #     resource of the MCA account, since we are effectively flattening the
        #     hierarchy."
        # @!attribute [rw] label_ids
        #   @return [::Array<::Integer>]
        #     Manually created label IDs assigned to the CSS/MC account by a CSS parent
        #     account.
        # @!attribute [rw] automatic_label_ids
        #   @return [::Array<::Integer>]
        #     Automatically created label IDs assigned to the MC account by
        #     CSS Center.
        # @!attribute [r] account_type
        #   @return [::Google::Shopping::Css::V1::Account::AccountType]
        #     Output only. The type of this account.
        class Account
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The account type.
          module AccountType
            # Unknown account type.
            ACCOUNT_TYPE_UNSPECIFIED = 0

            # CSS group account.
            CSS_GROUP = 1

            # CSS domain account.
            CSS_DOMAIN = 2

            # MC Primary CSS MCA account.
            MC_PRIMARY_CSS_MCA = 3

            # MC CSS MCA account.
            MC_CSS_MCA = 4

            # MC Marketplace MCA account.
            MC_MARKETPLACE_MCA = 5

            # MC Other MCA account.
            MC_OTHER_MCA = 6

            # MC Standalone account.
            MC_STANDALONE = 7

            # MC MCA sub-account.
            MC_MCA_SUBACCOUNT = 8
          end
        end
      end
    end
  end
end
