# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/maps/fleetengine/v1/vehicle_api_pb"
require "google/maps/fleet_engine/v1/vehicle_service"

class ::Google::Maps::FleetEngine::V1::VehicleService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_vehicle
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::Vehicle.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    parent = "hello world"
    vehicle_id = "hello world"
    vehicle = {}

    create_vehicle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_vehicle, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::CreateVehicleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["vehicle_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::Vehicle), request["vehicle"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_vehicle_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_vehicle({ header: header, parent: parent, vehicle_id: vehicle_id, vehicle: vehicle }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_vehicle header: header, parent: parent, vehicle_id: vehicle_id, vehicle: vehicle do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_vehicle ::Google::Maps::FleetEngine::V1::CreateVehicleRequest.new(header: header, parent: parent, vehicle_id: vehicle_id, vehicle: vehicle) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_vehicle({ header: header, parent: parent, vehicle_id: vehicle_id, vehicle: vehicle }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_vehicle(::Google::Maps::FleetEngine::V1::CreateVehicleRequest.new(header: header, parent: parent, vehicle_id: vehicle_id, vehicle: vehicle), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_vehicle_client_stub.call_rpc_count
    end
  end

  def test_get_vehicle
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::Vehicle.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    name = "hello world"
    current_route_segment_version = {}
    waypoints_version = {}

    get_vehicle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_vehicle, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::GetVehicleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["current_route_segment_version"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["waypoints_version"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_vehicle_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_vehicle({ header: header, name: name, current_route_segment_version: current_route_segment_version, waypoints_version: waypoints_version }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_vehicle header: header, name: name, current_route_segment_version: current_route_segment_version, waypoints_version: waypoints_version do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_vehicle ::Google::Maps::FleetEngine::V1::GetVehicleRequest.new(header: header, name: name, current_route_segment_version: current_route_segment_version, waypoints_version: waypoints_version) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_vehicle({ header: header, name: name, current_route_segment_version: current_route_segment_version, waypoints_version: waypoints_version }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_vehicle(::Google::Maps::FleetEngine::V1::GetVehicleRequest.new(header: header, name: name, current_route_segment_version: current_route_segment_version, waypoints_version: waypoints_version), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_vehicle_client_stub.call_rpc_count
    end
  end

  def test_delete_vehicle
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    name = "hello world"

    delete_vehicle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_vehicle, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::DeleteVehicleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_vehicle_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_vehicle({ header: header, name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_vehicle header: header, name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_vehicle ::Google::Maps::FleetEngine::V1::DeleteVehicleRequest.new(header: header, name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_vehicle({ header: header, name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_vehicle(::Google::Maps::FleetEngine::V1::DeleteVehicleRequest.new(header: header, name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_vehicle_client_stub.call_rpc_count
    end
  end

  def test_update_vehicle
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::Vehicle.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    name = "hello world"
    vehicle = {}
    update_mask = {}

    update_vehicle_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_vehicle, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::UpdateVehicleRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::Vehicle), request["vehicle"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_vehicle_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_vehicle({ header: header, name: name, vehicle: vehicle, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_vehicle header: header, name: name, vehicle: vehicle, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_vehicle ::Google::Maps::FleetEngine::V1::UpdateVehicleRequest.new(header: header, name: name, vehicle: vehicle, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_vehicle({ header: header, name: name, vehicle: vehicle, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_vehicle(::Google::Maps::FleetEngine::V1::UpdateVehicleRequest.new(header: header, name: name, vehicle: vehicle, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_vehicle_client_stub.call_rpc_count
    end
  end

  def test_update_vehicle_attributes
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    name = "hello world"
    attributes = [{}]

    update_vehicle_attributes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_vehicle_attributes, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["name"]
      assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleAttribute, request["attributes"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_vehicle_attributes_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_vehicle_attributes({ header: header, name: name, attributes: attributes }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_vehicle_attributes header: header, name: name, attributes: attributes do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_vehicle_attributes ::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest.new(header: header, name: name, attributes: attributes) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_vehicle_attributes({ header: header, name: name, attributes: attributes }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_vehicle_attributes(::Google::Maps::FleetEngine::V1::UpdateVehicleAttributesRequest.new(header: header, name: name, attributes: attributes), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_vehicle_attributes_client_stub.call_rpc_count
    end
  end

  def test_list_vehicles
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::ListVehiclesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    minimum_capacity = {}
    trip_types = [:UNKNOWN_TRIP_TYPE]
    maximum_staleness = {}
    vehicle_type_categories = [:UNKNOWN]
    required_attributes = ["hello world"]
    required_one_of_attributes = ["hello world"]
    required_one_of_attribute_sets = ["hello world"]
    vehicle_state = :UNKNOWN_VEHICLE_STATE
    on_trip_only = true
    filter = "hello world"
    viewport = {}

    list_vehicles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_vehicles, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::ListVehiclesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Int32Value), request["minimum_capacity"]
      assert_equal [:UNKNOWN_TRIP_TYPE], request["trip_types"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["maximum_staleness"]
      assert_equal [:UNKNOWN], request["vehicle_type_categories"]
      assert_equal ["hello world"], request["required_attributes"]
      assert_equal ["hello world"], request["required_one_of_attributes"]
      assert_equal ["hello world"], request["required_one_of_attribute_sets"]
      assert_equal :UNKNOWN_VEHICLE_STATE, request["vehicle_state"]
      assert_equal true, request["on_trip_only"]
      assert_equal "hello world", request["filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Geo::Type::Viewport), request["viewport"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_vehicles_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_vehicles({ header: header, parent: parent, page_size: page_size, page_token: page_token, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_type_categories: vehicle_type_categories, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, vehicle_state: vehicle_state, on_trip_only: on_trip_only, filter: filter, viewport: viewport }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_vehicles header: header, parent: parent, page_size: page_size, page_token: page_token, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_type_categories: vehicle_type_categories, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, vehicle_state: vehicle_state, on_trip_only: on_trip_only, filter: filter, viewport: viewport do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_vehicles ::Google::Maps::FleetEngine::V1::ListVehiclesRequest.new(header: header, parent: parent, page_size: page_size, page_token: page_token, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_type_categories: vehicle_type_categories, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, vehicle_state: vehicle_state, on_trip_only: on_trip_only, filter: filter, viewport: viewport) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_vehicles({ header: header, parent: parent, page_size: page_size, page_token: page_token, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_type_categories: vehicle_type_categories, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, vehicle_state: vehicle_state, on_trip_only: on_trip_only, filter: filter, viewport: viewport }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_vehicles(::Google::Maps::FleetEngine::V1::ListVehiclesRequest.new(header: header, parent: parent, page_size: page_size, page_token: page_token, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_type_categories: vehicle_type_categories, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, vehicle_state: vehicle_state, on_trip_only: on_trip_only, filter: filter, viewport: viewport), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_vehicles_client_stub.call_rpc_count
    end
  end

  def test_search_vehicles
    # Create GRPC objects.
    grpc_response = ::Google::Maps::FleetEngine::V1::SearchVehiclesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    header = {}
    parent = "hello world"
    pickup_point = {}
    dropoff_point = {}
    pickup_radius_meters = 42
    count = 42
    minimum_capacity = 42
    trip_types = [:UNKNOWN_TRIP_TYPE]
    maximum_staleness = {}
    vehicle_types = [{}]
    required_attributes = [{}]
    required_one_of_attributes = [{}]
    required_one_of_attribute_sets = [{}]
    order_by = :UNKNOWN_VEHICLE_MATCH_ORDER
    include_back_to_back = true
    trip_id = "hello world"
    current_trips_present = :CURRENT_TRIPS_PRESENT_UNSPECIFIED
    filter = "hello world"

    search_vehicles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_vehicles, name
      assert_kind_of ::Google::Maps::FleetEngine::V1::SearchVehiclesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::RequestHeader), request["header"]
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::TerminalLocation), request["pickup_point"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Maps::FleetEngine::V1::TerminalLocation), request["dropoff_point"]
      assert_equal 42, request["pickup_radius_meters"]
      assert_equal 42, request["count"]
      assert_equal 42, request["minimum_capacity"]
      assert_equal [:UNKNOWN_TRIP_TYPE], request["trip_types"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["maximum_staleness"]
      assert_kind_of ::Google::Maps::FleetEngine::V1::Vehicle::VehicleType, request["vehicle_types"].first
      assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleAttribute, request["required_attributes"].first
      assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleAttributeList, request["required_one_of_attributes"].first
      assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleAttributeList, request["required_one_of_attribute_sets"].first
      assert_equal :UNKNOWN_VEHICLE_MATCH_ORDER, request["order_by"]
      assert_equal true, request["include_back_to_back"]
      assert_equal "hello world", request["trip_id"]
      assert_equal :CURRENT_TRIPS_PRESENT_UNSPECIFIED, request["current_trips_present"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_vehicles_client_stub do
      # Create client
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_vehicles({ header: header, parent: parent, pickup_point: pickup_point, dropoff_point: dropoff_point, pickup_radius_meters: pickup_radius_meters, count: count, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_types: vehicle_types, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, order_by: order_by, include_back_to_back: include_back_to_back, trip_id: trip_id, current_trips_present: current_trips_present, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_vehicles header: header, parent: parent, pickup_point: pickup_point, dropoff_point: dropoff_point, pickup_radius_meters: pickup_radius_meters, count: count, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_types: vehicle_types, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, order_by: order_by, include_back_to_back: include_back_to_back, trip_id: trip_id, current_trips_present: current_trips_present, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_vehicles ::Google::Maps::FleetEngine::V1::SearchVehiclesRequest.new(header: header, parent: parent, pickup_point: pickup_point, dropoff_point: dropoff_point, pickup_radius_meters: pickup_radius_meters, count: count, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_types: vehicle_types, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, order_by: order_by, include_back_to_back: include_back_to_back, trip_id: trip_id, current_trips_present: current_trips_present, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_vehicles({ header: header, parent: parent, pickup_point: pickup_point, dropoff_point: dropoff_point, pickup_radius_meters: pickup_radius_meters, count: count, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_types: vehicle_types, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, order_by: order_by, include_back_to_back: include_back_to_back, trip_id: trip_id, current_trips_present: current_trips_present, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_vehicles(::Google::Maps::FleetEngine::V1::SearchVehiclesRequest.new(header: header, parent: parent, pickup_point: pickup_point, dropoff_point: dropoff_point, pickup_radius_meters: pickup_radius_meters, count: count, minimum_capacity: minimum_capacity, trip_types: trip_types, maximum_staleness: maximum_staleness, vehicle_types: vehicle_types, required_attributes: required_attributes, required_one_of_attributes: required_one_of_attributes, required_one_of_attribute_sets: required_one_of_attribute_sets, order_by: order_by, include_back_to_back: include_back_to_back, trip_id: trip_id, current_trips_present: current_trips_present, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_vehicles_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Maps::FleetEngine::V1::VehicleService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Maps::FleetEngine::V1::VehicleService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
