# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Maps
    module FleetEngine
      module V1
        # Vehicle metadata.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The unique name for this vehicle.
        #     The format is `providers/{provider}/vehicles/{vehicle}`.
        # @!attribute [rw] vehicle_state
        #   @return [::Google::Maps::FleetEngine::V1::VehicleState]
        #     The vehicle state.
        # @!attribute [rw] supported_trip_types
        #   @return [::Array<::Google::Maps::FleetEngine::V1::TripType>]
        #     Trip types supported by this vehicle.
        # @!attribute [r] current_trips
        #   @return [::Array<::String>]
        #     Output only. List of `trip_id`'s for trips currently assigned to this
        #     vehicle.
        # @!attribute [rw] last_location
        #   @return [::Google::Maps::FleetEngine::V1::VehicleLocation]
        #     Last reported location of the vehicle.
        # @!attribute [rw] past_locations
        #   @return [::Array<::Google::Maps::FleetEngine::V1::VehicleLocation>]
        #     Input only. Locations where this vehicle has been in the past that haven't
        #     yet been reported to Fleet Engine. This is used in `UpdateVehicleRequest`
        #     to record locations which were previously unable to be sent to the server.
        #     Typically this happens when the vehicle does not have internet
        #     connectivity.
        # @!attribute [rw] maximum_capacity
        #   @return [::Integer]
        #     The total numbers of riders this vehicle can carry.  The driver is not
        #     considered in this value. This value must be greater than or equal to one.
        # @!attribute [rw] attributes
        #   @return [::Array<::Google::Maps::FleetEngine::V1::VehicleAttribute>]
        #     List of vehicle attributes. A vehicle can have at most 100
        #     attributes, and each attribute must have a unique key.
        # @!attribute [rw] vehicle_type
        #   @return [::Google::Maps::FleetEngine::V1::Vehicle::VehicleType]
        #     Required. The type of this vehicle.  Can be used to filter vehicles in
        #     `SearchVehicles` results.  Also influences ETA and route calculations.
        # @!attribute [rw] license_plate
        #   @return [::Google::Maps::FleetEngine::V1::LicensePlate]
        #     License plate information for the vehicle.
        # @!attribute [rw] route
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Maps::FleetEngine::V1::TerminalLocation>]
        #     Deprecated: Use `Vehicle.waypoints` instead.
        # @!attribute [rw] current_route_segment
        #   @return [::String]
        #     The polyline specifying the route the driver app intends to take to
        #     the next waypoint. This list is also returned in
        #     `Trip.current_route_segment` for all active trips assigned to the vehicle.
        #
        #     Note: This field is intended only for use by the Driver SDK. Decoding is
        #     not yet supported.
        # @!attribute [rw] current_route_segment_traffic
        #   @return [::Google::Maps::FleetEngine::V1::TrafficPolylineData]
        #     Input only. Fleet Engine uses this information to improve journey sharing.
        #     Note: This field is intended only for use by the Driver SDK.
        # @!attribute [r] current_route_segment_version
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when `current_route_segment` was set. It can be stored by
        #     the client and passed in future `GetVehicle` requests to prevent returning
        #     routes that haven't changed.
        # @!attribute [rw] current_route_segment_end_point
        #   @return [::Google::Maps::FleetEngine::V1::TripWaypoint]
        #     The waypoint where `current_route_segment` ends. This can be supplied by
        #     drivers on `UpdateVehicle` calls either as a full trip waypoint, a waypoint
        #     `LatLng`, or as the last `LatLng` of the `current_route_segment`. Fleet
        #     Engine will then do its best to interpolate to an actual waypoint if it is
        #     not fully specified. This field is ignored in `UpdateVehicle` calls unless
        #     `current_route_segment` is also specified.
        # @!attribute [rw] remaining_distance_meters
        #   @return [::Google::Protobuf::Int32Value]
        #     The remaining driving distance for the `current_route_segment`.
        #     This value is also returned in `Trip.remaining_distance_meters` for all
        #     active trips assigned to the vehicle. The value is unspecified if the
        #     `current_route_segment` field is empty.
        # @!attribute [rw] eta_to_first_waypoint
        #   @return [::Google::Protobuf::Timestamp]
        #     The ETA to the first entry in the `waypoints` field.  The value is
        #     unspecified if the `waypoints` field is empty or the
        #     `Vehicle.current_route_segment` field is empty.
        #
        #     When updating a vehicle, `remaining_time_seconds` takes precedence over
        #     `eta_to_first_waypoint` in the same request.
        # @!attribute [rw] remaining_time_seconds
        #   @return [::Google::Protobuf::Int32Value]
        #     Input only. The remaining driving time for the `current_route_segment`. The
        #     value is unspecified if the `waypoints` field is empty or the
        #     `Vehicle.current_route_segment` field is empty. This value should match
        #     `eta_to_first_waypoint` - `current_time` if all parties are using the same
        #     clock.
        #
        #     When updating a vehicle, `remaining_time_seconds` takes precedence over
        #     `eta_to_first_waypoint` in the same request.
        # @!attribute [rw] waypoints
        #   @return [::Array<::Google::Maps::FleetEngine::V1::TripWaypoint>]
        #     The remaining waypoints assigned to this Vehicle.
        # @!attribute [r] waypoints_version
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Last time the `waypoints` field was updated. Clients should
        #     cache this value and pass it in `GetVehicleRequest` to ensure the
        #     `waypoints` field is only returned if it is updated.
        # @!attribute [rw] back_to_back_enabled
        #   @return [::Boolean]
        #     Indicates if the driver accepts back-to-back trips. If `true`,
        #     `SearchVehicles` may include the vehicle even if it is currently assigned
        #     to a trip. The default value is `false`.
        # @!attribute [rw] navigation_status
        #   @return [::Google::Maps::FleetEngine::V1::NavigationStatus]
        #     The vehicle's navigation status.
        # @!attribute [rw] device_settings
        #   @return [::Google::Maps::FleetEngine::V1::DeviceSettings]
        #     Input only. Information about settings in the mobile device being used by
        #     the driver.
        class Vehicle
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of vehicle.
          # @!attribute [rw] category
          #   @return [::Google::Maps::FleetEngine::V1::Vehicle::VehicleType::Category]
          #     Vehicle type category
          class VehicleType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Vehicle type categories
            module Category
              # Default, used for unspecified or unrecognized vehicle categories.
              UNKNOWN = 0

              # An automobile.
              AUTO = 1

              # Any vehicle that acts as a taxi (typically licensed or regulated).
              TAXI = 2

              # Generally, a vehicle with a large storage capacity.
              TRUCK = 3

              # A motorcycle, moped, or other two-wheeled vehicle
              TWO_WHEELER = 4

              # Human-powered transport.
              BICYCLE = 5

              # A human transporter, typically walking or running, traveling along
              # pedestrian pathways.
              PEDESTRIAN = 6
            end
          end
        end

        # Information about the device's battery.
        # @!attribute [rw] battery_status
        #   @return [::Google::Maps::FleetEngine::V1::BatteryStatus]
        #     Status of the battery, whether full or charging etc.
        # @!attribute [rw] power_source
        #   @return [::Google::Maps::FleetEngine::V1::PowerSource]
        #     Status of battery power source.
        # @!attribute [rw] battery_percentage
        #   @return [::Float]
        #     Current battery percentage [0-100].
        class BatteryInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about various settings on the mobile device.
        # @!attribute [rw] location_power_save_mode
        #   @return [::Google::Maps::FleetEngine::V1::LocationPowerSaveMode]
        #     How location features are set to behave on the device when battery saver is
        #     on.
        # @!attribute [rw] is_power_save_mode
        #   @return [::Boolean]
        #     Whether the device is currently in power save mode.
        # @!attribute [rw] is_interactive
        #   @return [::Boolean]
        #     Whether the device is in an interactive state.
        # @!attribute [rw] battery_info
        #   @return [::Google::Maps::FleetEngine::V1::BatteryInfo]
        #     Information about the battery state.
        class DeviceSettings
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The license plate information of the Vehicle.  To avoid storing
        # personally-identifiable information, only the minimum information
        # about the license plate is stored as part of the entity.
        # @!attribute [rw] country_code
        #   @return [::String]
        #     Required. CLDR Country/Region Code.  For example, `US` for United States,
        #     or `IN` for India.
        # @!attribute [rw] last_character
        #   @return [::String]
        #     The last digit of the license plate or "-1" to denote no numeric value
        #     is present in the license plate.
        #
        #     * "ABC 1234" -> "4"
        #     * "AB 123 CD" -> "3"
        #     * "ABCDEF" -> "-1"
        class LicensePlate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes how clients should color one portion of the polyline along the
        # route.
        # @!attribute [rw] road_stretch
        #   @return [::Array<::Google::Maps::FleetEngine::V1::VisualTrafficReportPolylineRendering::RoadStretch>]
        #     Optional. Road stretches that should be rendered along the polyline.
        #     Stretches are guaranteed to not overlap, and do not necessarily span the
        #     full route.
        #
        #     In the absence of a road stretch to style, the client should apply the
        #     default for the route.
        class VisualTrafficReportPolylineRendering
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # One road stretch that should be rendered.
          # @!attribute [rw] style
          #   @return [::Google::Maps::FleetEngine::V1::VisualTrafficReportPolylineRendering::RoadStretch::Style]
          #     Required. The style to apply.
          # @!attribute [rw] offset_meters
          #   @return [::Integer]
          #     Required. The style should be applied between `[offset_meters,
          #     offset_meters + length_meters)`.
          # @!attribute [rw] length_meters
          #   @return [::Integer]
          #     Required. The length of the path where to apply the style.
          class RoadStretch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The traffic style, indicating traffic speed.
            module Style
              # No style selected.
              STYLE_UNSPECIFIED = 0

              # Traffic is slowing down.
              SLOWER_TRAFFIC = 1

              # There is a traffic jam.
              TRAFFIC_JAM = 2
            end
          end
        end

        # Traffic conditions along the expected vehicle route.
        # @!attribute [rw] traffic_rendering
        #   @return [::Google::Maps::FleetEngine::V1::VisualTrafficReportPolylineRendering]
        #     A polyline rendering of how fast traffic is for all regions along
        #     one stretch of a customer ride.
        class TrafficPolylineData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The state of a `Vehicle`.
        module VehicleState
          # Default, used for unspecified or unrecognized vehicle states.
          UNKNOWN_VEHICLE_STATE = 0

          # The vehicle is not accepting new trips. Note: the vehicle may continue to
          # operate in this state while completing a trip assigned to it.
          OFFLINE = 1

          # The vehicle is accepting new trips.
          ONLINE = 2
        end

        # How location features are configured to behave on the mobile device when the
        # devices "battery saver" feature is on.
        # (https://developer.android.com/reference/android/os/PowerManager#getLocationPowerSaveMode())
        module LocationPowerSaveMode
          # Undefined LocationPowerSaveMode
          UNKNOWN_LOCATION_POWER_SAVE_MODE = 0

          # Either the location providers shouldn't be affected by battery saver, or
          # battery saver is off.
          LOCATION_MODE_NO_CHANGE = 1

          # The GPS based location provider should be disabled when battery saver is on
          # and the device is non-interactive.
          LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 2

          # All location providers should be disabled when battery saver is on and the
          # device is non-interactive.
          LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 3

          # All the location providers will be kept available, but location fixes
          # should only be provided to foreground apps.
          LOCATION_MODE_FOREGROUND_ONLY = 4

          # Location will not be turned off, but LocationManager will throttle all
          # requests to providers when the device is non-interactive.
          LOCATION_MODE_THROTTLE_REQUESTS_WHEN_SCREEN_OFF = 5
        end

        # Status of the battery, whether full or charging etc.
        module BatteryStatus
          # Battery status unknown.
          UNKNOWN_BATTERY_STATUS = 0

          # Battery is being charged.
          BATTERY_STATUS_CHARGING = 1

          # Battery is discharging.
          BATTERY_STATUS_DISCHARGING = 2

          # Battery is full.
          BATTERY_STATUS_FULL = 3

          # Battery is not charging.
          BATTERY_STATUS_NOT_CHARGING = 4

          # Battery is low on power.
          BATTERY_STATUS_POWER_LOW = 5
        end

        # Type of the charger being used to charge the battery.
        module PowerSource
          # Power source unknown.
          UNKNOWN_POWER_SOURCE = 0

          # Power source is an AC charger.
          POWER_SOURCE_AC = 1

          # Power source is a USB port.
          POWER_SOURCE_USB = 2

          # Power source is wireless.
          POWER_SOURCE_WIRELESS = 3

          # Battery is unplugged.
          POWER_SOURCE_UNPLUGGED = 4
        end
      end
    end
  end
end
