# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Maps
    module FleetEngine
      module V1
        # Traffic density indicator on a contiguous segment of a path. Given a path
        # with points P_0, P_1, ... , P_N (zero-based index), the SpeedReadingInterval
        # defines an interval and describes its traffic using the following categories.
        # @!attribute [rw] start_polyline_point_index
        #   @return [::Integer]
        #     The starting index of this interval in the path.
        #     In JSON, when the index is 0, the field will appear to be unpopulated.
        # @!attribute [rw] end_polyline_point_index
        #   @return [::Integer]
        #     The ending index of this interval in the path.
        #     In JSON, when the index is 0, the field will appear to be unpopulated.
        # @!attribute [rw] speed
        #   @return [::Google::Maps::FleetEngine::V1::SpeedReadingInterval::Speed]
        #     Traffic speed in this interval.
        class SpeedReadingInterval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The classification of polyline speed based on traffic data.
          module Speed
            # Default value. This value is unused.
            SPEED_UNSPECIFIED = 0

            # Normal speed, no traffic delays.
            NORMAL = 1

            # Slowdown detected, medium amount of traffic.
            SLOW = 2

            # Traffic delays.
            TRAFFIC_JAM = 3
          end
        end

        # Traffic density along a Vehicle's path.
        # @!attribute [rw] speed_reading_interval
        #   @return [::Array<::Google::Maps::FleetEngine::V1::SpeedReadingInterval>]
        #     Traffic speed along the path from the previous waypoint to the current
        #     waypoint.
        # @!attribute [rw] encoded_path_to_waypoint
        #   @return [::String]
        #     The path the driver is taking from the previous waypoint to the current
        #     waypoint. This path has landmarks in it so clients can show traffic markers
        #     along the path (see `speed_reading_interval`).  Decoding is not yet
        #     supported.
        class ConsumableTrafficPolyline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
